/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.FrontendConnection;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.authenticate.server.AuthenticateProvider;
import com.meidusa.toolkit.util.TimeUtil;
import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public abstract class AuthingableFrontendConnection
extends FrontendConnection {
    private static final long AUTH_TIMEOUT = 15000L;
    protected boolean isAuthenticated;
    protected String seed;
    protected AuthenticateProvider<AuthingableFrontendConnection> authenticateProvider;
    private MessageHandler<? extends AuthingableFrontendConnection> requestHandler;

    public AuthenticateProvider<AuthingableFrontendConnection> getAuthenticateProvider() {
        return this.authenticateProvider;
    }

    public MessageHandler<? extends AuthingableFrontendConnection> getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(MessageHandler<AuthingableFrontendConnection> requestHandler) {
        this.requestHandler = requestHandler;
    }

    public void setAuthenticateProvider(AuthenticateProvider<AuthingableFrontendConnection> authenticateProvider) {
        this.authenticateProvider = authenticateProvider;
    }

    public AuthingableFrontendConnection(SocketChannel channel) {
        super(channel);
    }

    public void setAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
        if (isAuthenticated) {
            this.setHandler(this.requestHandler);
        }
    }

    public String getSeed() {
        return this.seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    @Override
    public boolean isIdleTimeout() {
        if (this.isAuthenticated) {
            return false;
        }
        return TimeUtil.currentTimeMillis() > Math.max(this.lastWriteTime, this.lastReadTime) + 15000L;
    }

    @Override
    public void register(Selector selector) throws IOException {
        super.register(selector);
        if (this.authenticateProvider != null && !this.isClosed.get()) {
            this.setHandler(this.authenticateProvider);
            this.authenticateProvider.beforeAuthing(this);
        }
    }
}

