/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.util;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public class InetAddressUtil {
    public static int pack(byte[] bytes) {
        int val = 0;
        for (int i = 0; i < bytes.length; ++i) {
            val = val << 8 | bytes[i] & 0xFF;
        }
        return val;
    }

    public static byte[] unpack(int bytes) {
        return new byte[]{(byte)(bytes >>> 24 & 0xFF), (byte)(bytes >>> 16 & 0xFF), (byte)(bytes >>> 8 & 0xFF), (byte)(bytes & 0xFF)};
    }

    public static String intToAddress(int value) {
        return InetAddressUtil.addressToString(InetAddressUtil.unpack(value));
    }

    public static String addressToString(byte[] src) {
        return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
    }

    public static void main(String[] args) throws Exception {
        long time = System.nanoTime();
        String host = "192.127.255.255";
        for (int i = 0; i < 1; ++i) {
            String target = InetAddressUtil.addressToString(InetAddressUtil.unpack(InetAddressUtil.pack(InetAddress.getByName(host).getAddress())));
            System.out.println(target);
        }
        System.err.println(TimeUnit.MILLISECONDS.convert(System.nanoTime() - time, TimeUnit.NANOSECONDS));
    }
}

