/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.HeartbeatManager;
import com.meidusa.toolkit.common.heartbeat.Status;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.net.GenericHeartbeatDelayed;
import com.meidusa.toolkit.net.ValidatorMessageHandler;
import com.meidusa.toolkit.net.factory.BackendConnectionFactory;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingBackendConnectionPool<F extends BackendConnectionFactory, V extends BackendConnection>
implements BackendConnectionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingBackendConnectionPool.class);
    private static int HEATBEAT_INTERVAL = Integer.getInteger("heartbeat.interval", HeartbeatManager.DEFAULT_HEATBEAT_INTERVAL);
    private volatile long currentCounter = 0L;
    private final F factory;
    private final int size;
    private final BackendConnection[] items;
    private String name;
    private boolean valid = true;
    private boolean closed = false;
    private final Map<Integer, Object> lockMap = new HashMap<Integer, Object>();
    private GenericHeartbeatDelayed delay;

    public PollingBackendConnectionPool(String name, F factory, int size) {
        this.size = size;
        this.items = new BackendConnection[size];
        this.factory = factory;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackendConnection borrowObject() throws Exception {
        BackendConnection conn = null;
        for (int j = 0; j < this.size; ++j) {
            int i;
            if ((conn = this.items[i = (int)(this.currentCounter++ % (long)this.size)]) == null) {
                Object lockObject;
                Object object = lockObject = this.lockMap.get(i);
                synchronized (object) {
                    conn = this.items[i];
                    if (conn == null) {
                        conn = this.items[i] = ((BackendConnectionFactory)this.factory).make();
                        conn.setPool(this);
                    }
                }
            }
            if (!conn.isClosed()) {
                conn.setActive(true);
                return conn;
            }
            this.items[i] = null;
        }
        this.setValid(false);
        throw new InvalidObjectException("invalid pool=" + this.name);
    }

    @Override
    public void returnObject(BackendConnection c) {
        c.setActive(false);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.delay != null) {
            HeartbeatManager.removeHeartbeat((HeartbeatDelayed)this.delay);
        }
        for (BackendConnection conn : this.items) {
            if (conn == null || conn.isClosed()) continue;
            conn.close();
        }
    }

    @Override
    public int getActive() {
        return this.items.length;
    }

    @Override
    public void deActive(BackendConnection c) {
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean b) {
        this.valid = b;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void init() {
        int i;
        this.delay = new GenericHeartbeatDelayed(HEATBEAT_INTERVAL, TimeUnit.SECONDS, this){
            Status last;
            {
                this.last = Status.VALID;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Status doCheck() {
                Status status = this.check0();
                try {
                    if (this.last == Status.INVALID && status == Status.VALID) {
                        for (int i = 0; i < PollingBackendConnectionPool.this.size; ++i) {
                            status = this.check0();
                            if (status != Status.INVALID) continue;
                            Status status2 = status;
                            return status2;
                        }
                        Status status3 = status;
                        return status3;
                    }
                    Status status4 = status;
                    return status4;
                }
                finally {
                    this.last = status;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Status check0() {
                BackendConnection conn = null;
                try {
                    conn = this.pool.borrowObject();
                    if (conn != null) {
                        if (conn.isClosed()) {
                            this.pool.setValid(false);
                            Status status = Status.INVALID;
                            return status;
                        }
                        BackendConnection other = null;
                        ValidatorMessageHandler handler = PollingBackendConnectionPool.this.factory.createValidatorMessageHandler();
                        if (handler != null) {
                            try {
                                other = PollingBackendConnectionPool.this.factory.make();
                                if (!other.isClosed()) {
                                    other.setHandler(handler);
                                    handler.doCheck(other);
                                    Status status = handler.getResult(conn);
                                    if (status == Status.VALID) {
                                        this.pool.setValid(true);
                                        Status status2 = Status.VALID;
                                        return status2;
                                    }
                                    this.pool.setValid(false);
                                    Status status3 = status;
                                    return status3;
                                }
                            }
                            finally {
                                if (other != null) {
                                    other.close();
                                }
                            }
                        }
                        this.pool.setValid(true);
                        Status status = Status.VALID;
                        return status;
                    }
                    Status other = Status.INVALID;
                    return other;
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    this.pool.setValid(false);
                    Status status = Status.INVALID;
                    return status;
                }
                finally {
                    if (conn != null) {
                        this.pool.returnObject(conn);
                    }
                }
            }
        };
        for (i = 0; i < this.items.length; ++i) {
            this.lockMap.put(i, new Object());
        }
        for (i = 0; i < this.items.length; ++i) {
            try {
                this.items[i] = ((BackendConnectionFactory)this.factory).make();
                continue;
            }
            catch (IOException e) {
                LOGGER.error("init pool error ,name=" + this.name, (Throwable)e);
                this.setValid(false);
                break;
            }
        }
        HeartbeatManager.addHeartbeat((HeartbeatDelayed)this.delay);
    }
}

