/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.FrontendConnection;
import com.meidusa.toolkit.net.factory.FrontendConnectionFactory;
import com.meidusa.toolkit.net.util.LoopingThread;
import com.meidusa.toolkit.util.IdGenerator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionAcceptor
extends LoopingThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionAcceptor.class);
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private int port;
    private Selector selector;
    private ServerSocketChannel serverChannel;
    private FrontendConnectionFactory connectionFactory;
    protected ConnectionManager[] processors;
    private int executorSize = Runtime.getRuntime().availableProcessors();
    private int nextProcessor;
    private long acceptCount;

    public ConnectionAcceptor() {
    }

    public ConnectionAcceptor(String name, int port, FrontendConnectionFactory factory) {
        super.setName(name);
        this.port = port;
        this.connectionFactory = factory;
    }

    public FrontendConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(FrontendConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public int getExecutorSize() {
        return this.executorSize;
    }

    public void setExecutorSize(int executorSize) {
        this.executorSize = executorSize;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public long getAcceptCount() {
        return this.acceptCount;
    }

    public void setProcessors(ConnectionManager[] processors) {
        this.processors = processors;
    }

    public void initProcessors() throws IOException {
        if (this.processors == null) {
            this.processors = new ConnectionManager[Runtime.getRuntime().availableProcessors()];
            for (int i = 0; i < this.processors.length; ++i) {
                this.processors[i] = new ConnectionManager(this.getName() + "-Manager-" + i, this.getExecutorSize());
                this.processors[i].start();
            }
        }
    }

    @Override
    protected void willStart() {
        try {
            this.initProcessors();
            this.selector = Selector.open();
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.socket().bind(new InetSocketAddress(this.port));
            LOGGER.warn("Server listening on " + this.serverChannel.socket().getLocalSocketAddress() + ".");
            this.serverChannel.configureBlocking(false);
            this.serverChannel.register(this.selector, 16);
            super.willStart();
        }
        catch (IOException ioe) {
            LOGGER.error("Failure listening to socket on port '" + this.port + "'.", (Throwable)ioe);
            this._running = false;
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterate() throws Throwable {
        ++this.acceptCount;
        this.selector.select(1000L);
        Set<SelectionKey> keys = this.selector.selectedKeys();
        try {
            for (SelectionKey key : keys) {
                if (key.isValid() && key.isAcceptable()) {
                    this.accept();
                    continue;
                }
                key.cancel();
            }
        }
        finally {
            keys.clear();
        }
    }

    private void accept() {
        SocketChannel channel = null;
        try {
            channel = this.serverChannel.accept();
            channel.configureBlocking(false);
            FrontendConnection c = this.connectionFactory.make(channel);
            c.setAccepted(true);
            c.setId(ID_GENERATOR.nextId());
            ConnectionManager processor = this.nextProcessor();
            c.setProcessor(processor);
            processor.postRegister(c);
        }
        catch (Throwable e) {
            ConnectionAcceptor.closeChannel(channel);
            LOGGER.warn(this.getName(), e);
        }
    }

    private ConnectionManager nextProcessor() {
        if (++this.nextProcessor == this.processors.length) {
            this.nextProcessor = 0;
        }
        return this.processors[this.nextProcessor];
    }

    private static void closeChannel(SocketChannel channel) {
        if (channel == null) {
            return;
        }
        Socket socket = channel.socket();
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void handleIterateFailure(Throwable e) {
        if (e instanceof ClosedSelectorException) {
            super.handleIterateFailure(e);
        } else if (e instanceof InterruptedException) {
            super.handleIterateFailure(e);
        } else {
            LOGGER.error(this.getName(), e);
        }
    }

    public void finalize() throws Throwable {
        LOGGER.warn("Server port: " + this.serverChannel.socket().getLocalSocketAddress() + " closed!");
        super.finalize();
    }
}

