/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.Status;
import com.meidusa.toolkit.net.BackendConnection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BackendConnectionPool {
    public String getName();

    public BackendConnection borrowObject() throws Exception;

    public void returnObject(BackendConnection var1);

    public void close();

    public int getActive();

    public void deActive(BackendConnection var1);

    public boolean isValid();

    public void setValid(boolean var1);

    public void init();

    public boolean isClosed();

    public static class ObjectPoolHeartbeatDelayed
    extends HeartbeatDelayed {
        protected static Logger logger = LoggerFactory.getLogger(ObjectPoolHeartbeatDelayed.class);
        protected BackendConnectionPool pool;

        public boolean isCycle() {
            return false;
        }

        public BackendConnectionPool getPool() {
            return this.pool;
        }

        public ObjectPoolHeartbeatDelayed(long nsTime, TimeUnit timeUnit, BackendConnectionPool pool) {
            super(nsTime, timeUnit);
            this.pool = pool;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectPoolHeartbeatDelayed) {
                ObjectPoolHeartbeatDelayed other = (ObjectPoolHeartbeatDelayed)((Object)obj);
                return other.pool == this.pool && ((Object)((Object)this)).getClass() == obj.getClass();
            }
            return false;
        }

        public int hashCode() {
            return this.pool == null ? ((Object)((Object)this)).getClass().hashCode() : ((Object)((Object)this)).getClass().hashCode() + this.pool.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Status doCheck() {
            BackendConnection conn = null;
            try {
                conn = this.pool.borrowObject();
                if (conn != null) {
                    if (conn.isClosed()) {
                        this.pool.setValid(false);
                        Status status = Status.INVALID;
                        return status;
                    }
                    this.pool.setValid(true);
                    Status status = Status.VALID;
                    return status;
                }
                Status status = Status.INVALID;
                return status;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                this.pool.setValid(false);
                Status status = Status.INVALID;
                return status;
            }
            finally {
                if (conn != null) {
                    this.pool.returnObject(conn);
                }
            }
        }

        public String getName() {
            return this.pool.getName();
        }
    }
}

