/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.type;

import com.meidusa.fastjson.type.DefinedParameterizedType;
import java.awt.List;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Set;

public class DefinedParameterizedTypeBuilder {
    public static Type buildDefinedType(Type type, Map<TypeVariable<?>, Type> typeMap) {
        if (type instanceof ParameterizedType) {
            ParameterizedType castType = (ParameterizedType)type;
            DefinedParameterizedType definedParameterizedType = new DefinedParameterizedType();
            definedParameterizedType.setRawType((Class)castType.getRawType());
            definedParameterizedType.setOwnerType(castType.getOwnerType());
            Type[] actualTypes = castType.getActualTypeArguments();
            Type[] actualDefinedTypes = new Type[actualTypes.length];
            for (int i = 0; i < actualTypes.length; ++i) {
                if (actualTypes[i] instanceof Class) {
                    actualDefinedTypes[i] = actualTypes[i];
                    continue;
                }
                if (actualTypes[i] instanceof TypeVariable) {
                    actualDefinedTypes[i] = typeMap.get(actualTypes[i]);
                    if (actualDefinedTypes[i] != null) continue;
                    Type[] bounds = ((TypeVariable)actualTypes[i]).getBounds();
                    Type[] organizedBounds = new Type[bounds.length];
                    for (int j = 0; j < bounds.length; ++j) {
                        organizedBounds[i] = DefinedParameterizedTypeBuilder.buildDefinedType(bounds[0], typeMap);
                    }
                    actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.chooseFromBounds(organizedBounds);
                    actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.buildDefinedType(actualDefinedTypes[i], typeMap);
                    continue;
                }
                if (actualTypes[i] instanceof WildcardType) {
                    actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.chooseFromBounds(((WildcardType)actualTypes[i]).getUpperBounds());
                    actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.buildDefinedType(actualDefinedTypes[i], typeMap);
                    continue;
                }
                if (!(actualTypes[i] instanceof ParameterizedType)) continue;
                actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.buildDefinedType(actualTypes[i], typeMap);
            }
            definedParameterizedType.setActualTypes(actualDefinedTypes);
            return definedParameterizedType;
        }
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return typeMap.get(type);
        }
        if (type instanceof WildcardType) {
            return DefinedParameterizedTypeBuilder.chooseFromBounds(((WildcardType)type).getUpperBounds());
        }
        return null;
    }

    public static Type chooseFromBounds(Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            Class typeRawClass = null;
            if (types[i] instanceof ParameterizedType) {
                typeRawClass = (Class)((ParameterizedType)types[i]).getRawType();
            } else if (types[i] instanceof Class) {
                typeRawClass = (Class)types[i];
            }
            if (typeRawClass == null) continue;
            if (!typeRawClass.isInterface()) {
                return types[i];
            }
            if (typeRawClass != List.class && typeRawClass != Map.class && typeRawClass != Set.class) continue;
            return types[i];
        }
        return Object.class;
    }

    public static void buildTypeVariableMap(Type type, Map<TypeVariable<?>, Type> map) {
        Class rawType = null;
        if (type instanceof ParameterizedType) {
            Type[] actualArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type[] organizedArguments = new Type[actualArguments.length];
            for (int i = 0; i < actualArguments.length; ++i) {
                organizedArguments[i] = DefinedParameterizedTypeBuilder.buildDefinedType(actualArguments[i], map);
            }
            rawType = (Class)((ParameterizedType)type).getRawType();
            TypeVariable<Class<T>>[] variables = rawType.getTypeParameters();
            for (int i = 0; i < actualArguments.length; ++i) {
                map.put(variables[i], organizedArguments[i]);
            }
        } else if (type instanceof Class) {
            rawType = (Class)type;
        }
        Type[] interfaces = rawType.getGenericInterfaces();
        Type superClass = rawType.getGenericSuperclass();
        for (int i = 0; i < interfaces.length; ++i) {
            DefinedParameterizedTypeBuilder.buildTypeVariableMap(interfaces[i], map);
        }
        if (superClass != null && superClass != Object.class) {
            DefinedParameterizedTypeBuilder.buildTypeVariableMap(superClass, map);
        }
    }
}

