/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.serializer.FieldSerializer;
import com.meidusa.fastjson.serializer.FilterUtils;
import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.NumberFieldSerializer;
import com.meidusa.fastjson.serializer.ObjectFieldSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.type.DefinedParameterizedTypeBuilder;
import com.meidusa.fastjson.util.FieldInfo;
import com.meidusa.fastmark.Serialize;
import com.meidusa.fastmark.TypeHandle;
import com.meidusa.fastmark.TypeHandleKey;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class JavaBeanSerializer
implements ObjectSerializer {
    private final FieldSerializer[] getters;

    public FieldSerializer[] getGetters() {
        return this.getters;
    }

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) {
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        List<FieldInfo> fieldInfoList = JavaBeanSerializer.computeGetters(clazz, aliasMap);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
    }

    protected boolean isWriteClassName(JSONSerializer serializer) {
        return serializer.isEnabled(SerializerFeature.WriteClassName);
    }

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        Object[] getters = this.getters;
        if (out.isEnabled(SerializerFeature.SortField)) {
            Arrays.sort(getters);
        }
        try {
            out.append('{');
            boolean commaFlag = false;
            if (this.isWriteClassName(serializer)) {
                out.writeFieldName("class");
                serializer.write(object.getClass());
                commaFlag = true;
            }
            for (int i = 0; i < getters.length; ++i) {
                Field field;
                Object fieldSerializer = getters[i];
                if (serializer.isEnabled(SerializerFeature.SkipTransientField) && (field = ((FieldSerializer)fieldSerializer).getField()) != null && Modifier.isTransient(field.getModifiers())) continue;
                Object propertyValue = ((FieldSerializer)fieldSerializer).getPropertyValue(object);
                if (!FilterUtils.apply(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue)) continue;
                String key = FilterUtils.processKey(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue);
                Object originalValue = propertyValue;
                propertyValue = FilterUtils.processValue(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue);
                if (propertyValue == null && !((FieldSerializer)fieldSerializer).isWriteNull() && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
                if (commaFlag) {
                    out.append(',');
                }
                if (StringUtils.equals((String)key, (String)((FieldSerializer)fieldSerializer).getName())) {
                    out.writeFieldName(key);
                    serializer.write(propertyValue);
                } else if (originalValue != propertyValue) {
                    ((FieldSerializer)fieldSerializer).writePrefix(serializer);
                    serializer.write(propertyValue);
                } else {
                    ((FieldSerializer)fieldSerializer).writeProperty(serializer, propertyValue);
                }
                commaFlag = true;
            }
            out.append('}');
        }
        catch (Exception e) {
            throw new JSONException("write javaBean error", e);
        }
    }

    public FieldSerializer createFieldSerializer(FieldInfo fieldInfo) {
        Class<?> clazz = fieldInfo.getMethod().getReturnType();
        if (clazz == Number.class) {
            return new NumberFieldSerializer(fieldInfo);
        }
        return new ObjectFieldSerializer(fieldInfo);
    }

    public static Set<String> getTypeHandleKey(Class<?> clazz, Class<?> stopClazz) {
        HashSet<String> keySets = new HashSet<String>();
        for (Class<?> superClazz = clazz; superClazz != stopClazz && superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
            Field[] fields;
            TypeHandle typeHandle = superClazz.getAnnotation(TypeHandle.class);
            if (typeHandle != null && typeHandle.key() != null) {
                keySets.add(typeHandle.key());
            }
            for (Field field : fields = superClazz.getDeclaredFields()) {
                TypeHandleKey typeHandlekey = field.getAnnotation(TypeHandleKey.class);
                if (typeHandlekey == null) continue;
                keySets.add(field.getName());
            }
        }
        return keySets;
    }

    public static Map<String, Field> getAllFields(Class<?> clazz, Class<?> stopClazz) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Class<?> superClazz = clazz; superClazz != stopClazz && superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = superClazz.getDeclaredFields()) {
                fieldMap.put(field.getName(), field);
            }
        }
        return fieldMap;
    }

    public static List<FieldInfo> computeGetters(Type type, Map<String, String> aliasMap) {
        HashMap variableMap = new HashMap();
        DefinedParameterizedTypeBuilder.buildTypeVariableMap(type, variableMap);
        Class clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        }
        Set<String> handleKey = JavaBeanSerializer.getTypeHandleKey(clazz, Object.class);
        TreeMap<String, FieldInfo> getterMap = new TreeMap<String, FieldInfo>();
        for (Method method : clazz.getMethods()) {
            Serialize fieldAnnotation;
            Field field;
            String propertyName;
            String methodName = method.getName();
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            Serialize annotation = method.getAnnotation(Serialize.class);
            if (annotation != null) {
                if (!annotation.serialize()) continue;
                if (annotation.name().length() != 0) {
                    propertyName = annotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                    getterMap.put(propertyName, new FieldInfo(propertyName, method, variableMap, null, handleKey.contains(propertyName)));
                    continue;
                }
            }
            if (methodName.startsWith("get")) {
                if (methodName.length() < 4 || methodName.equals("getClass") || !Character.isUpperCase(methodName.charAt(3))) continue;
                propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                field = ParserConfig.getField(clazz, propertyName);
                if (field != null && (fieldAnnotation = field.getAnnotation(Serialize.class)) != null && fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                }
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                getterMap.put(propertyName, new FieldInfo(propertyName, method, variableMap, field, handleKey.contains(propertyName)));
            }
            if (!methodName.startsWith("is") || methodName.length() < 3 || !Character.isUpperCase(methodName.charAt(2))) continue;
            propertyName = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            field = ParserConfig.getField(clazz, propertyName);
            if (field != null && (fieldAnnotation = field.getAnnotation(Serialize.class)) != null && fieldAnnotation.name().length() != 0) {
                propertyName = fieldAnnotation.name();
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            getterMap.put(propertyName, new FieldInfo(propertyName, method, variableMap, field, handleKey.contains(propertyName)));
        }
        return new LinkedList<FieldInfo>(getterMap.values());
    }
}

