/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.math.BigInteger;

public class BigIntegerSerializer
implements ObjectSerializer {
    public static final BigIntegerSerializer instance = new BigIntegerSerializer();

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                out.write('0');
            } else {
                out.writeNull();
            }
            return;
        }
        BigInteger val = (BigInteger)object;
        out.write(val.toString());
    }
}

