/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicLongArraySerializer
implements ObjectSerializer {
    public static final AtomicLongArraySerializer instance = new AtomicLongArraySerializer();

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        AtomicLongArray array = (AtomicLongArray)object;
        int len = array.length();
        out.append('[');
        for (int i = 0; i < len; ++i) {
            long val = array.get(i);
            if (i != 0) {
                out.write(',');
            }
            out.writeLong(val);
        }
        out.append(']');
    }
}

