/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastmark.feature.Feature;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;

public class HashSetStringDeserializer
implements ObjectDeserializer {
    public static final HashSetStringDeserializer instance = new HashSetStringDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        HashSet set = new HashSet();
        HashSetStringDeserializer.parseArray(parser, set);
        return (T)set;
    }

    public static void parseArray(DefaultExtJSONParser parser, Collection array) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() != 14) {
            throw new JSONException("exepct '[', but " + lexer.token());
        }
        lexer.nextToken(4);
        while (true) {
            String value;
            if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                while (lexer.token() == 16) {
                    lexer.nextToken();
                }
            }
            if (lexer.token() == 15) break;
            if (lexer.token() == 4) {
                value = lexer.stringVal();
                lexer.nextToken(16);
            } else {
                Object obj = parser.parse();
                value = obj == null ? null : obj.toString();
            }
            array.add(value);
            if (lexer.token() != 16) continue;
            lexer.nextToken(4);
        }
        lexer.nextToken(16);
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

