/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson;

import com.meidusa.fastjson.JSON;
import com.meidusa.fastjson.JSONAware;
import com.meidusa.fastjson.JSONObject;
import com.meidusa.fastjson.util.TypeUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class JSONArray<T>
extends JSON
implements List<T>,
JSONAware,
Cloneable,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<T> list;

    public JSONArray() {
        this.list = new ArrayList<T>(10);
    }

    public JSONArray(List<T> list) {
        this.list = list;
    }

    public JSONArray(int initialCapacity) {
        this.list = new ArrayList<T>(initialCapacity);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    public JSONObject getJSONObject(int index) {
        T value = this.list.get(index);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return (JSONObject)JSONArray.toJSON(value);
    }

    public JSONArray getJSONArray(int index) {
        T value = this.list.get(index);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return (JSONArray)JSONArray.toJSON(value);
    }

    public <T> T getObject(int index, Class<T> clazz) {
        T obj = this.list.get(index);
        return TypeUtils.castToJavaBean(obj, clazz);
    }

    public Boolean getBoolean(int index) {
        T value = this.get(index);
        return TypeUtils.castToBoolean(value);
    }

    public boolean getBooleanValue(int index) {
        T value = this.get(index);
        if (value == null) {
            return false;
        }
        return TypeUtils.castToBoolean(value);
    }

    public Byte getByte(int index) {
        T value = this.get(index);
        return TypeUtils.castToByte(value);
    }

    public byte getByteValue(int index) {
        T value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToByte(value);
    }

    public Short getShort(int index) {
        T value = this.get(index);
        return TypeUtils.castToShort(value);
    }

    public short getShortValue(int index) {
        T value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToShort(value);
    }

    public Integer getInteger(int index) {
        T value = this.get(index);
        return TypeUtils.castToInt(value);
    }

    public int getIntValue(int index) {
        T value = this.get(index);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToInt(value);
    }

    public Long getLong(int index) {
        T value = this.get(index);
        return TypeUtils.castToLong(value);
    }

    public long getLongValue(int index) {
        T value = this.get(index);
        if (value == null) {
            return 0L;
        }
        return TypeUtils.castToLong(value);
    }

    public Float getFloat(int index) {
        T value = this.get(index);
        return TypeUtils.castToFloat(value);
    }

    public float getFloatValue(int index) {
        T value = this.get(index);
        if (value == null) {
            return 0.0f;
        }
        return TypeUtils.castToFloat(value).floatValue();
    }

    public Double getDouble(int index) {
        T value = this.get(index);
        return TypeUtils.castToDouble(value);
    }

    public double getDoubleValue(int index) {
        T value = this.get(index);
        if (value == null) {
            return 0.0;
        }
        return TypeUtils.castToDouble(value).floatValue();
    }

    public BigDecimal getBigDecimal(int index) {
        T value = this.get(index);
        return TypeUtils.castToBigDecimal(value);
    }

    public BigInteger getBigInteger(int index) {
        T value = this.get(index);
        return TypeUtils.castToBigInteger(value);
    }

    public String getString(int index) {
        T value = this.get(index);
        return TypeUtils.castToString(value);
    }

    public java.util.Date getDate(int index) {
        T value = this.get(index);
        return TypeUtils.castToDate(value);
    }

    public Date getSqlDate(int index) {
        T value = this.get(index);
        return TypeUtils.castToSqlDate(value);
    }

    public Timestamp getTimestamp(int index) {
        T value = this.get(index);
        return TypeUtils.castToTimestamp(value);
    }

    public Object clone() {
        return new JSONArray<T>(new ArrayList<T>(this.list));
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }
}

