/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SoftCache
extends AbstractMap {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();
    private Set entrySet = null;

    private void processQueue() {
        ValueCell valuecell;
        while ((valuecell = (ValueCell)this.queue.poll()) != null) {
            if (valuecell.isValid()) {
                this.hash.remove(valuecell.key);
                continue;
            }
            ValueCell.dropped--;
        }
    }

    public SoftCache(int i, float f) {
        this.hash = new HashMap(i, f);
    }

    public SoftCache(int i) {
        this.hash = new HashMap(i);
    }

    public SoftCache() {
        this.hash = new HashMap();
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object obj) {
        return ValueCell.strip(this.hash.get(obj), false) != null;
    }

    protected Object fill(Object obj) {
        return null;
    }

    @Override
    public Object get(Object obj) {
        this.processQueue();
        Object obj1 = this.hash.get(obj);
        if (obj1 == null && (obj1 = this.fill(obj)) != null) {
            this.hash.put(obj, ValueCell.create(obj, obj1, this.queue));
            return obj1;
        }
        return ValueCell.strip(obj1, false);
    }

    @Override
    public Object put(Object obj, Object obj1) {
        this.processQueue();
        ValueCell valuecell = ValueCell.create(obj, obj1, this.queue);
        return ValueCell.strip(this.hash.put(obj, valuecell), true);
    }

    @Override
    public Object remove(Object obj) {
        this.processQueue();
        return ValueCell.strip(this.hash.remove(obj), true);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private static boolean valEquals(Object obj, Object obj1) {
        return obj != null ? obj.equals(obj1) : obj1 == null;
    }

    @Override
    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private static class ValueCell
    extends SoftReference {
        private static Object INVALID_KEY = new Object();
        private static int dropped = 0;
        private Object key;

        private static ValueCell create(Object obj, Object obj1, ReferenceQueue referencequeue) {
            if (obj1 == null) {
                return null;
            }
            return new ValueCell(obj, obj1, referencequeue);
        }

        private static Object strip(Object obj, boolean flag) {
            if (obj == null) {
                return null;
            }
            ValueCell valuecell = (ValueCell)obj;
            Object obj1 = valuecell.get();
            if (flag) {
                valuecell.drop();
            }
            return obj1;
        }

        private boolean isValid() {
            return this.key != INVALID_KEY;
        }

        private void drop() {
            super.clear();
            this.key = INVALID_KEY;
            ++dropped;
        }

        private ValueCell(Object obj, Object obj1, ReferenceQueue referencequeue) {
            super(obj1, referencequeue);
            this.key = obj;
        }
    }

    private class EntrySet
    extends AbstractSet {
        Set hashEntries;

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = EntrySet.this.hashEntries.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)this.hashIterator.next();
                        ValueCell valuecell = (ValueCell)entry.getValue();
                        Object obj = null;
                        if (valuecell != null) {
                            Object t = valuecell.get();
                            obj = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(entry, obj);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry entry = this.next;
                    this.next = null;
                    return entry;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int i = 0;
            Iterator iterator1 = this.iterator();
            while (iterator1.hasNext()) {
                ++i;
                iterator1.next();
            }
            return i;
        }

        @Override
        public boolean remove(Object obj) {
            SoftCache.this.processQueue();
            if (obj instanceof Entry) {
                return this.hashEntries.remove(((Entry)obj).ent);
            }
            return false;
        }

        private EntrySet() {
            this.hashEntries = SoftCache.this.hash.entrySet();
        }
    }

    private class Entry
    implements Map.Entry {
        private Map.Entry ent;
        private Object value;

        Entry(Map.Entry entry, Object obj) {
            this.ent = entry;
            this.value = obj;
        }

        public Object getKey() {
            return this.ent.getKey();
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object obj) {
            return this.ent.setValue(ValueCell.create(this.ent.getKey(), obj, SoftCache.this.queue));
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return SoftCache.valEquals(this.ent.getKey(), entry.getKey()) && SoftCache.valEquals(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            Object obj = this.getKey();
            return (obj != null ? obj.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
        }
    }
}

