/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueueMap
implements Map {
    List values;
    List keys;
    Map keyToValue;

    public QueueMap() {
        this.values = new LinkedList();
        this.keys = new LinkedList();
        this.keyToValue = new HashMap();
    }

    public QueueMap(Map t) {
        this.values = new ArrayList();
        this.keys = new ArrayList();
        this.keyToValue = new HashMap();
        this.putAll(t);
    }

    @Override
    public void clear() {
        this.values.clear();
        this.keys.clear();
        this.keyToValue.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValue.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keyToValue.containsValue(value);
    }

    public Set entrySet() {
        HashSet<KeyValuePair> result = new HashSet<KeyValuePair>(this.keys.size(), 1.0f);
        for (int i = 0; i < this.keys.size(); ++i) {
            result.add(new KeyValuePair(this.keys.get(i), this.values.get(i)));
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.keyToValue).equals(o);
    }

    public Object get(Object key) {
        return this.keyToValue.get(key);
    }

    @Override
    public int hashCode() {
        return ((Object)this.keyToValue).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValue.isEmpty();
    }

    public Set keySet() {
        HashSet result = new HashSet(this.keys.size(), 1.0f);
        for (int i = 0; i < this.keys.size(); ++i) {
            result.add(this.keys.get(i));
        }
        return result;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            return null;
        }
        if (this.keys.contains(key)) {
            this.values.remove(this.keys.indexOf(key));
            this.values.add(this.keys.indexOf(key), value);
        } else {
            this.values.add(value);
            this.keys.add(key);
        }
        return this.keyToValue.put(key, value);
    }

    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        for (Object aKey : t.keySet()) {
            this.put(aKey, t.get(aKey));
        }
    }

    public Object remove(Object key) {
        int i;
        if (key == null) {
            return null;
        }
        Object value = null;
        if (this.containsKey(key) && (i = this.values.indexOf(value = this.keyToValue.remove(key))) != -1) {
            this.keys.remove(i);
            this.values.remove(i);
        }
        return value;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public List keys() {
        return this.keys;
    }

    public Collection values() {
        return this.values;
    }

    public Object getValueForKey(Object key) {
        return this.keyToValue.get(key);
    }

    public Object getKeyForValue(Object value) {
        int i = this.values.indexOf(value);
        if (i != -1) {
            return this.keys.get(i);
        }
        return null;
    }

    public Object getFirstKey() {
        if (this.keys.size() < 1) {
            return null;
        }
        return this.keys.get(0);
    }

    public Object getLastKey() {
        if (this.keys.size() < 1) {
            return null;
        }
        return this.keys.get(this.keys.size() - 1);
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int j = 0; j <= max; ++j) {
            buf.append(this.keys.get(j) + "=" + this.values.get(j));
            if (j >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public static void main(String[] argv) {
        int i;
        QueueMap qMap = new QueueMap();
        for (i = 0; i < 5; ++i) {
            qMap.put(Integer.toString(i), Integer.toString(i));
        }
        System.out.println("\nMap = " + qMap);
        System.out.println("Keys = " + qMap.keys());
        System.out.println("Values = " + qMap.values());
        qMap = new QueueMap();
        for (i = 0; i < 5; ++i) {
            qMap.put(Integer.toString(i), "A");
        }
        System.out.println("\nMap = " + qMap);
        System.out.println("Keys = " + qMap.keys());
        System.out.println("Values = " + qMap.values());
        qMap = new QueueMap();
        for (i = 0; i < 5; ++i) {
            qMap.put(Integer.toString(i), (Object)null);
        }
        System.out.println("\nMap = " + qMap);
        System.out.println("Keys = " + qMap.keys());
        System.out.println("Values = " + qMap.values());
        HashMap<String, String> aMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < 5; ++i2) {
            aMap.put(Integer.toString(i2), Integer.toString(i2));
        }
        qMap = new QueueMap(aMap);
        System.out.println("\nHashMap = " + aMap);
        System.out.println("Map = " + qMap);
        System.out.println("Keys = " + qMap.keys());
        System.out.println("Values = " + qMap.values());
        qMap = new QueueMap();
        qMap.put("Test1", "String1");
        qMap.put("Test2", "String2");
        qMap.put("Test3", "String3");
        qMap.put("Test4", "String4");
        qMap.put("Test5", "String5");
        System.out.println("\nStandard Test, Map = " + qMap);
        qMap.put("Test6", "String6");
        qMap.put("Test7", "String7");
        System.out.println("Put New Test, Map = " + qMap);
        qMap.put("Test2", "New String2");
        qMap.put("Test6", "New String6");
        System.out.println("Put Existing Test, Map = " + qMap);
        qMap.put("Test5", (Object)null);
        qMap.put("Test8", (Object)null);
        System.out.println("Put Null Test, Map = " + qMap);
        qMap.remove("Test1");
        qMap.remove("Test3");
        qMap.remove("Test5");
        qMap.remove("Test9");
        System.out.println("Remove Test, Map = " + qMap);
        System.out.println("             Keys = " + qMap.keys());
        System.out.println("             Values = " + qMap.values());
        qMap.clear();
        qMap.put("Test10", "String10");
        qMap.put("Test11", "String11");
        qMap.put("Test12", "String12");
        System.out.println("Clear Test, Map = " + qMap);
        aMap = new HashMap();
        aMap.put("Test10", "String10");
        aMap.put("Test11", "String11");
        aMap.put("Test12", "String12");
        System.out.println("Equality Test, Equal = " + qMap.equals(aMap));
    }

    public static class KeyValuePair
    implements Map.Entry {
        Object key;
        Object value;

        public KeyValuePair(Object aKey, Object aValue) {
            this.key = aKey;
            this.value = aValue;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object aValue) {
            Object result = this.value;
            this.value = aValue;
            return result;
        }

        @Override
        public boolean equals(Object o) {
            KeyValuePair p;
            return o instanceof KeyValuePair && this.key.equals((p = (KeyValuePair)o).getKey()) && this.value.equals(p.getValue());
        }
    }
}

