package com.meidusa.toolkit.common.util.regex;

import com.meidusa.toolkit.common.util.collection.Predicate;

import java.util.Collection;
import java.util.Collections;

import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;

/**
 * һƥcontext.  һcontextбһλƥпظʹõĶ, ԼһƥĽ.
 *
 * @version 
 * 
 */
public class MatchContext {
    private PatternMatcher      matcher;
    private PatternMatcherInput input;
    private Substitution        substitution;
    private MatchItem           lastMatchItem;

    /**
     * һµcontext.
     *
     * @param input Ҫƥַ
     */
    public MatchContext(String input) {
        init(input);
    }

    /**
     * һµcontext.
     *
     * @param input Ҫƥַ
     */
    public void init(String input) {
        if (this.matcher == null) {
            this.matcher = createPatternMatcher();
        }

        if (this.input == null) {
            this.input = new PatternMatcherInput(input);
        } else {
            this.input.setInput(input);
        }
    }

    /**
     * ȡƥpatterns.
     *
     * @return patterns
     */
    public Collection getPatterns() {
        return Collections.EMPTY_LIST;
    }

    /**
     * ȡڹƥ, ĬϷ<code>null</code>.
     *
     * @return ƥ
     */
    public Predicate getPredicate() {
        return null;
    }

    /**
     * ȡƥֵ.
     *
     * @return ƥֵ
     */
    public PatternMatcherInput getInput() {
        return input;
    }

    /**
     * ȡòλƥֵ. ÿƥ䶯ɺ, ô˷ſɽеڶƥ.
     *
     * @return input ƥֵ
     */
    public PatternMatcherInput getInputReset() {
        input.setCurrentOffset(input.getBeginOffset());
        return input;
    }

    /**
     * ȡpatternƥ.
     *
     * @return patternƥ
     */
    public PatternMatcher getMatcher() {
        return matcher;
    }

    /**
     * һƥĽ.
     *
     * @param item һƥĽ
     */
    public void setLastMatchItem(MatchItem item) {
        this.lastMatchItem = item;
    }

    /**
     * ȡһƥĽ.
     *
     * @return һƥĽ
     */
    public MatchItem getLastMatchItem() {
        return lastMatchItem;
    }

    /**
     * ȡ滻.
     *
     * @param substitution 滻ַ
     *
     * @return 滻
     */
    public Substitution getSubstitution(String substitution) {
        this.substitution = createSubstitution(this.substitution, substitution);

        return this.substitution;
    }

    /**
     * ʽƥ, ĬΪ<code>Perl5Matcher</code>, Ըıʵ.
     *
     * @return ʽƥ
     */
    protected PatternMatcher createPatternMatcher() {
        return new Perl5Matcher();
    }

    /**
     * 滻, ĬΪ<code>Perl5Substitution</code>, Ըıʵ.
     *
     * @param reuse         õ滻
     * @param substitution  滻ַ
     *
     * @return 滻
     */
    protected Substitution createSubstitution(Substitution reuse, String substitution) {
        if (reuse == null) {
            return new Perl5Substitution(substitution);
        }

        ((Perl5Substitution) reuse).setSubstitution(substitution);
        return reuse;
    }

    /**
     * ƥ, ĬΪ<code>MatchItem</code>, Ըıʵ.
     *
     * @param pattern  ƥpattern
     * @param result   ʽƥ
     *
     * @return ƥ
     */
    protected MatchItem createMatchItem(MatchPattern pattern, MatchResult result) {
        return new MatchItem(this, pattern, result);
    }
}