package com.meidusa.toolkit.common.util.regex;

import com.meidusa.toolkit.common.util.collection.Predicate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/**
 * ƥ, ͼƥһ. жͬƥ䳤, 򷵻صһƥ.
 *
 * @version 
 * 
 */
public class BestMatchStrategy implements MatchStrategy {
    /** ƥ䳤ȴӴСıȽ. */
    private static final Comparator MATCH_LENGTH_COMPARATOR =
            new Comparator() {
        public int compare(Object item1, Object item2) {
            return ((MatchItem) item2).length() - ((MatchItem) item1).length();
        }
    };

    /**
     * ͼƥֵָ. ɹ, 򷵻<code>true</code>.  ߿ͨ<code>context.getMatchItem()</code>ȡƥ.
     *
     * @param context  ƥ
     *
     * @return ƥɹ, 򷵻<code>true</code>
     */
    public boolean matches(MatchContext context) {
        Predicate predicate = context.getPredicate();

        // ûpredicate, ѡʹøЧĲ
        if (predicate == null) {
            return matchWithoutPredicate(context);
        }

        Collection patterns      = context.getPatterns();
        List       matchItemList = new ArrayList(patterns.size());

        for (Iterator i = patterns.iterator(); i.hasNext();) {
            MatchPattern pattern = (MatchPattern) i.next();

            if (pattern.matches(context)) {
                matchItemList.add(context.getLastMatchItem());
            }
        }

        // ƥ, ֱӷnull
        if (matchItemList.size() == 0) {
            return false;
        }


        // ƥ䳤ɴС(ȶ)
        Collections.sort(matchItemList, MATCH_LENGTH_COMPARATOR);

        // ָͨpredicateƥ
        for (Iterator i = matchItemList.iterator(); i.hasNext();) {
            MatchItem item = (MatchItem) i.next();

            if (predicate.evaluate(item)) {
                context.setLastMatchItem(item);
                return true;
            }
        }

        return false;
    }

    /**
     * ͼƥֵָ, жpredicate, нϸߵЧ.
     *
     * @param context  ƥ
     *
     * @return ƥɹ, 򷵻<code>true</code>
     */
    private boolean matchWithoutPredicate(MatchContext context) {
        MatchItem bestMatchItem   = null;
        int       bestMatchLength = -1;

        for (Iterator i = context.getPatterns().iterator(); i.hasNext();) {
            MatchPattern pattern = (MatchPattern) i.next();

            if (pattern.matches(context)) {
                MatchItem matchItem   = context.getLastMatchItem();
                int       matchLength = matchItem.length();

                if (matchLength > bestMatchLength) {
                    bestMatchItem   = matchItem;
                    bestMatchLength = matchLength;
                }
            }
        }

        if (bestMatchItem != null) {
            context.setLastMatchItem(bestMatchItem);
            return true;
        }

        return false;
    }
}