package com.meidusa.toolkit.common.util.matcher;

import org.apache.commons.lang.StringUtils;

/**
 * 
 * @author Struct
 *
 */
public class EqualsMatcher extends AbstractStringMatcher {
	private boolean ignoreCase = false;
	private boolean not = false;
	
	public boolean isNot() {
		return not;
	}

	public void setNot(boolean not) {
		this.not = not;
	}

	public boolean isIgnoreCase() {
		return ignoreCase;
	}
	
	public void setIgnoreCase(boolean ignoreCase) {
		this.ignoreCase = ignoreCase;
	}
	
	public boolean match(String inputStr) {
		if(!not){
			if(ignoreCase){
				return StringUtils.equalsIgnoreCase(this.getPattern(), inputStr);
			}else{
				return StringUtils.equals(this.getPattern(), inputStr);
			}
		}else{
			if(ignoreCase){
				return !StringUtils.equalsIgnoreCase(this.getPattern(), inputStr);
			}else{
				return !StringUtils.equals(this.getPattern(), inputStr);
			}
		}
		
	}

}
