package com.meidusa.toolkit.common.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * ָĹ<code>Predicate</code>, ָ<code>Iterator</code>.
 *
 * @version 
 * 
 */
public class GrepIterator extends FilterIterator {
    private Predicate predicate;
    private Object    nextObject;
    private boolean   nextObjectSet = false;

    /**
     * һ<code>GrepIterator</code>.
     *
     * @param iterator  ˵<code>Iterator</code>
     * @param predicate 
     */
    public GrepIterator(Iterator iterator, Predicate predicate) {
        super(iterator);
        this.predicate = predicate;
    }

    /**
     * ȡ"".
     *
     * @return ""
     */
    public Predicate getPredicate() {
        return predicate;
    }

    /**
     * жǷһԪ.
     *
     * @return һԪ, 򷵻<code>true</code>
     */
    public boolean hasNext() {
        if (nextObjectSet) {
            return true;
        } else {
            return setNextObject();
        }
    }

    /**
     * ȡһԪ.
     *
     * @return һ¸Ԫ
     */
    public Object next() {
        if (!nextObjectSet && !setNextObject()) {
            throw new NoSuchElementException();
        }

        nextObjectSet = false;
        return nextObject;
    }

    /**
     * ɾصԪ, ֧.
     */
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /**
     * һõԪ.
     *
     * @return ûһԪ, 򷵻<code>false</code>, 򷵻<code>true</code>
     */
    private boolean setNextObject() {
        Iterator  iterator  = getIterator();
        Predicate predicate = getPredicate();

        while (iterator.hasNext()) {
            Object object = iterator.next();

            if (predicate.evaluate(object)) {
                nextObject    = object;
                nextObjectSet = true;
                return true;
            }
        }

        return false;
    }
}

