package com.meidusa.toolkit.common.util.collection;

import java.io.IOException;
import java.io.Serializable;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/**
 * <p>
 * Hashһʵ, ʵ<code>Map</code>ӿ.
 * </p>
 *
 * <p>
 * hashʵȫJDK<code>HashMap</code>, ¸ı, Ա, ʵ⹦:
 * </p>
 *
 * <ul>
 * <li>
 * Աóprotectedfriendly
 * </li>
 * <li>
 * һЩ¼
 * </li>
 * </ul>
 *
 * <p>
 * JDK<code>HashMap</code>һ, ʵ־:
 * </p>
 *
 * <ul>
 * <li>
 * ֵ֧Ϊ<code>null</code>keyvalue
 * </li>
 * <li>
 * ûнκ<code>synchronized</code>, ̰߳ȫ. ͨ²ʵ̰߳ȫ:
 * </li>
 * </ul>
 *
 * <pre style="margin-left:48.0">
 *  Map m = Collections.synchronizedMap(new DefaultHashMap(...));
 * </pre>
 *
 * <ul>
 * <li>
 * ֤hashеentry˳
 * </li>
 * <li>
 * Լⶨܴȡhashеÿentry
 * </li>
 * <li>
 * hashȡõκ<code>Iterator</code><i>fail-fast</i>: hashĽṹıʱ,
 * <code>Iterator.remove</code><code>Iterator.add</code>ʱ,
 * <code>ConcurrentModificationException</code>. ȷֲȷ.
 * </li>
 * </ul>
 *
 *
 * @version 
 * 
 */
public class DefaultHashMap extends AbstractMap implements Map, Cloneable, Serializable {
    /* ============================================================================ */
    /*                                                                          */
    /* ============================================================================ */

    /** Ĭϵĳʼ - <code>2</code>. */
    private static final int DEFAULT_INITIAL_CAPACITY = 16;

    /**  - <code>2</code>. */
    private static final int MAXIMUM_CAPACITY = 1 << 30;

    /** Ĭϵĸϵ */
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    /* ============================================================================ */
    /* Ա                                                                     */
    /* ============================================================================ */

    /** Hash, ȿɱ - ȱ<code>2</code>. */
    protected transient Entry[] table;

    /** Hashеentry. */
    protected transient int size;

    /**
     * ֵ. hashеentryʱ, Զ(<code>resize</code>).
     * ֵ<code>capacity&times;loadFactor</code>.
     *
     * @serial Զлֶ
     */
    protected int threshold;

    /**
     * ϵ.
     *
     * @serial Զлֶ
     */
    protected final float loadFactor;

    /**
     * hash&quot;ṹı&quot;ļ. ν&quot;ṹı&quot;,
     * ָhashentryĿıڲṹı(<code>resize</code>). ֶΪʵ<i>fail-fast</i>.
     */
    protected transient volatile int modCount;

    /** keyļͼ. */
    private transient Set keySet = null;

    /** entryļͼ. */
    private transient Set entrySet = null;

    /** valueļͼ. */
    private transient Collection values = null;

    /* ============================================================================ */
    /* 캯                                                                     */
    /* ============================================================================ */

    /**
     * һյhash. ʹָĬϵĳʼ(16)Ĭϵĸϵ(0.75).
     */
    public DefaultHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, DEFAULT_LOAD_FACTOR);
    }

    /**
     * һյhash. ʹָĳʼֵĬϵĸϵ(0.75).
     *
     * @param initialCapacity ʼ.
     */
    public DefaultHashMap(int initialCapacity) {
        this(initialCapacity, DEFAULT_LOAD_FACTOR);
    }

    /**
     * һյhash. ʹָĳʼ͸ϵ.
     *
     * @param initialCapacity ʼ
     * @param loadFactor ϵ.
     */
    public DefaultHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }

        if (initialCapacity > MAXIMUM_CAPACITY) {
            initialCapacity = MAXIMUM_CAPACITY;
        }

        if ((loadFactor <= 0) || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }

        // ȷʼΪ2.
        int capacity = 1;

        while (capacity < initialCapacity) {
            capacity <<= 1;
        }

        this.loadFactor = loadFactor;
        this.threshold  = (int) (capacity * loadFactor);
        this.table      = new Entry[capacity];

        onInit();
    }

    /**
     * ָ<code>Map</code>ͬ<code>HashMap</code>. ʹĬϵĸϵ(0.75).
     *
     * @param map ҪƵ<code>Map</code>
     */
    public DefaultHashMap(Map map) {
        this(Math.max((int) (map.size() / DEFAULT_LOAD_FACTOR) + 1, DEFAULT_INITIAL_CAPACITY),
             DEFAULT_LOAD_FACTOR);
        putAllForCreate(map);
    }

    /* ============================================================================ */
    /* ʵMapӿڵķ                                                            */
    /* ============================================================================ */

    /**
     * hashentryĸ.
     *
     * @return hashеentry.
     */
    public int size() {
        return size;
    }

    /**
     * жǷΪյhash.
     *
     * @return Ϊ(<code>size() == 0</code>), 򷵻<code>true</code>.
     */
    public boolean isEmpty() {
        return size == 0;
    }

    /**
     * ָkeyӦvalue. hashûvalueӦkey, 򷵻<code>null</code>.
     * Ƿ<code>null</code>ǴûvalueӦָkey, Ҳпָ valueֵΪ<code>null</code>.
     * ͨ<code>containsKey</code> .
     *
     * @param key ָkeyӦvalue.
     *
     * @return ָkeyӦvalue, ûvalueӦkey, 򷵻<code>null</code>.
     */
    public Object get(Object key) {
        Entry entry = getEntry(key);

        return (entry == null) ? null
                               : entry.getValue();
    }

    /**
     * hashаָkeyentry, 򷵻<code>true</code>.
     *
     * @param key   ָkeyǷ.
     *
     * @return keyӦentry, 򷵻<code>true</code>.
     */
    public boolean containsKey(Object key) {
        Entry entry = getEntry(key);

        return entry != null;
    }

    /**
     * ָvaluekey. Ѿvalueʹkey, ȡ֮,  رȡvalue.
     *
     * @param key Ҫkey
     * @param value Ҫkeyvalue
     *
     * @return Ѿںʹkeyvalue, 򷵻شvalue. 򷵻<code>null</code>.
     *         <code>null</code>ҲΪȡvalueֵΪ<code>null</code>.
     */
    public Object put(Object key, Object value) {
        Entry entry = getEntry(key);

        if (entry != null) {
            Object oldValue = entry.getValue();

            entry.setValue(value);
            entry.onAccess();

            return oldValue;
        } else {
            modCount++;

            // еֵ, .
            if (size >= threshold) {
                resize(table.length * 2);
            }

            addEntry(key, value);

            return null;
        }
    }

    /**
     * <code>Map</code>е뵽ǰ<code>Map</code>. ͬkey, 滻֮.
     *
     * @param map Ҫ<code>Map</code>
     */
    public void putAll(Map map) {
        // һ, ԱԼentry.
        int n = map.size();

        if (n == 0) {
            return;
        }

        if (n >= threshold) {
            n = (int) (n / loadFactor + 1);

            if (n > MAXIMUM_CAPACITY) {
                n = MAXIMUM_CAPACITY;
            }

            int capacity = table.length;

            while (capacity < n) {
                capacity <<= 1;
            }

            resize(capacity);
        }

        for (Iterator i = map.entrySet().iterator(); i.hasNext();) {
            Map.Entry entry = (Map.Entry) i.next();

            put(entry.getKey(), entry.getValue());
        }
    }

    /**
     * ָkeyentryhashɾ(entryڵĻ).
     *
     * @param key Ҫɾentrykey
     *
     * @return ɾentryvalue. entry, 򷵻<code>null</code>.
     *         Ƿ<code>null</code>ǴûvalueӦָkey, Ҳпָ valueֵΪ<code>null</code>.
     */
    public Object remove(Object key) {
        Entry entry = removeEntryForKey(key);

        return ((entry == null) ? null
                                : entry.getValue());
    }

    /**
     * hashеentry.
     */
    public void clear() {
        modCount++;
        Arrays.fill(table, null);
        size = 0;
    }

    /**
     * жhashǷһentryָvalue.
     *
     * @param value ҪԵvalue
     *
     * @return һentryָvalue, 򷵻<code>true</code>
     */
    public boolean containsValue(Object value) {
        Entry[] tab = table;

        for (int i = 0; i < tab.length; i++) {
            for (Entry entry = tab[i]; entry != null; entry = entry.next) {
                if (eq(value, entry.getValue())) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * ȡkeyļͼ. hashΪ, κhashĸı, ᷴ䵽, ֮Ȼ. ü֧ɾ,
     * ɾеkeyɾhashеӦentry. ͨ·ɾһentry: <code>Iterator.remove</code>,
     * <code>Set.remove</code>, <code>removeAll</code>, <code>retainAll</code>,
     * <code>clear</code>. ϲ֧<code>add</code><code>addAll</code>.
     *
     * @return keyļͼ
     */
    public Set keySet() {
        Set ks = keySet;

        return ((ks != null) ? ks
                             : (keySet = new KeySet()));
    }

    /**
     * ȡvalueļͼ. hashΪ, κhashĸı, ᷴ䵽, ֮Ȼ. ü֧ɾ,
     * ɾеkeyɾhashеӦentry. ͨ·ɾһentry: <code>Iterator.remove</code>,
     * <code>Collection.remove</code>, <code>removeAll</code>, <code>retainAll</code>,
     * <code>clear</code>. ϲ֧<code>add</code><code>addAll</code>.
     *
     * @return valueļͼ
     */
    public Collection values() {
        Collection vs = values;

        return ((vs != null) ? vs
                             : (values = new Values()));
    }

    /**
     * ȡentryļͼ. hashΪ, κhashĸı, ᷴ䵽, ֮Ȼ. ü֧ɾ,
     * ɾеkeyɾhashеӦentry. ͨ·ɾһentry: <code>Iterator.remove</code>,
     * <code>Set.remove</code>, <code>removeAll</code>, <code>retainAll</code>,
     * <code>clear</code>. ϲ֧<code>add</code><code>addAll</code>.
     *
     * @return entryļͼ
     */
    public Set entrySet() {
        Set es = entrySet;

        return ((es != null) ? es
                             : (entrySet = new EntrySet()));
    }

    /* ============================================================================ */
    /* ڲ                                                                       */
    /* ============================================================================ */

    /**
     * <code>Map.Entry</code>ʵ.
     */
    protected static class Entry extends DefaultMapEntry {
        /** keyhashֵ. */
        protected final int hash;

        /** ͬhashֵentryķʽŵ, ָеһentry. */
        protected Entry next;

        /**
         * һµentry.
         *
         * @param h keyhashֵ
         * @param k entrykey
         * @param v entryvalue
         * @param n еһentry
         */
        protected Entry(int h, Object k, Object v, Entry n) {
            super(k, v);
            next = n;
            hash = h;
        }

        /**
         * <code>put(key, value)</code>ʱ, entryѾڽʱ, ˷.
         */
        protected void onAccess() {
        }

        /**
         * entryɾʱ, ˷.
         */
        protected void onRemove() {
        }
    }

    /**
     * .
     */
    private abstract class HashIterator implements Iterator {
        /** ǰentry. */
        private Entry current;

        /** һҪصentry. */
        private Entry next;

        /** iteratorʱ޸ļ. */
        private int expectedModCount;

        /** ǰλ. */
        private int index;

        /**
         * һ.
         */
        protected HashIterator() {
            expectedModCount = modCount;

            Entry[] t = table;
            int     i = t.length;
            Entry   n = null;

            if (size != 0) { // advance to first entry

                while ((i > 0) && ((n = t[--i]) == null)) {
                    ;
                }
            }

            next  = n;
            index = i;
        }

        /**
         * رǷһentry.
         *
         * @return лһentry, <code>true</code>
         */
        public boolean hasNext() {
            return next != null;
        }

        /**
         * ɾһǰentry. ִǰִ<code>next()</code>.
         */
        public void remove() {
            if (current == null) {
                throw new IllegalStateException();
            }

            checkForComodification();

            Object k = current.getKey();

            current = null;
            DefaultHashMap.this.removeEntryForKey(k);
            expectedModCount = modCount;
        }

        /**
         * ȡһentry.
         *
         * @return һentry
         */
        protected Entry nextEntry() {
            checkForComodification();

            Entry entry = next;

            if (entry == null) {
                throw new NoSuchElementException();
            }

            Entry   n = entry.next;
            Entry[] t = table;
            int     i = index;

            while ((n == null) && (i > 0)) {
                n = t[--i];
            }

            index = i;
            next  = n;

            return current = entry;
        }

        /**
         * Ƿͬʱ޸.
         */
        private void checkForComodification() {
            if (modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /**
     * ȡhashkeyı.
     */
    private class KeyIterator extends HashIterator {
        /**
         * ȡһkey.
         *
         * @return һkey
         */
        public Object next() {
            return nextEntry().getKey();
        }
    }

    /**
     * ȡhashvalueı.
     */
    private class ValueIterator extends HashIterator {
        /**
         * ȡһvalue.
         *
         * @return һvalue
         */
        public Object next() {
            return nextEntry().getValue();
        }
    }

    /**
     * ȡhashentryı.
     */
    private class EntryIterator extends HashIterator {
        /**
         * ȡһentry.
         *
         * @return һentry
         */
        public Object next() {
            return nextEntry();
        }
    }

    /**
     * keyļͼ.
     */
    private class KeySet extends AbstractSet {
        /**
         * ȡkeyı.
         *
         * @return keyı
         */
        public Iterator iterator() {
            return newKeyIterator();
        }

        /**
         * ȡüϵĴС, hashentry.
         *
         * @return hashentry
         */
        public int size() {
            return size;
        }

        /**
         * жkeyǷָ.
         *
         * @param o ҪҵĶ
         *
         * @return keyаָĶ, 򷵻<code>true</code>
         */
        public boolean contains(Object o) {
            return containsKey(o);
        }

        /**
         * hashɾkeyΪָentry.
         *
         * @param o ָkey
         *
         * @return ɾɹ, 򷵻<code>true</code>
         */
        public boolean remove(Object o) {
            return DefaultHashMap.this.removeEntryForKey(o) != null;
        }

        /**
         * entry.
         */
        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    /**
     * valueļͼ.
     */
    private class Values extends AbstractCollection {
        /**
         * ȡvalueı.
         *
         * @return valueı
         */
        public Iterator iterator() {
            return newValueIterator();
        }

        /**
         * ȡüϵĴС, hashentry.
         *
         * @return hashentry
         */
        public int size() {
            return size;
        }

        /**
         * жvalueǷָ.
         *
         * @param o ҪҵĶ
         *
         * @return valueаָĶ, 򷵻<code>true</code>
         */
        public boolean contains(Object o) {
            return containsValue(o);
        }

        /**
         * entry.
         */
        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    /**
     * entryļͼ.
     */
    private class EntrySet extends AbstractSet {
        /**
         * ȡentryı.
         *
         * @return entryı
         */
        public Iterator iterator() {
            return newEntryIterator();
        }

        /**
         * жentryǷָ.
         *
         * @param o ҪҵĶ
         *
         * @return entryǷָ, 򷵻<code>true</code>
         */
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }

            Map.Entry entry     = (Map.Entry) o;
            Entry     candidate = getEntry(entry.getKey());

            return eq(candidate, entry);
        }

        /**
         * hashɾָentry.
         *
         * @param o Ҫɾentry
         *
         * @return ɾɹ, 򷵻<code>true</code>
         */
        public boolean remove(Object o) {
            return removeEntry(o) != null;
        }

        /**
         * ȡüϵĴС, hashentry.
         *
         * @return hashentry
         */
        public int size() {
            return size;
        }

        /**
         * entry.
         */
        public void clear() {
            DefaultHashMap.this.clear();
        }
    }

    /* ============================================================================ */
    /* л                                                                       */
    /* ============================================================================ */

    /** л汾. */
    private static final long serialVersionUID = 362498820763181265L;

    /**
     * ؽhash(ҲǷл).
     *
     * @param is 
     *
     * @exception IOException 쳣
     * @exception ClassNotFoundException δҵ
     */
    private void readObject(java.io.ObjectInputStream is) throws IOException,
                                                                 ClassNotFoundException {
        // threshold, loadfactor, صĶ.
        is.defaultReadObject();

        // ȡhash.
        int numBuckets = is.readInt();

        table = new Entry[numBuckets];


        // һʼ.
        onInit();

        // hashentryĸ.
        int size = is.readInt();

        // еentry.
        for (int i = 0; i < size; i++) {
            Object key   = is.readObject();
            Object value = is.readObject();

            putForCreate(key, value);
        }
    }

    /**
     * hash״̬浽(Ҳ&quot;л&quot;).
     *
     * @param os 
     *
     * @exception IOException 쳣
     */
    private void writeObject(java.io.ObjectOutputStream os) throws IOException {
        // threshold, loadfactor, صĶ.
        os.defaultWriteObject();


        // hash.
        os.writeInt(table.length);


        // hashĴС.
        os.writeInt(size);

        // entry.
        for (Iterator i = entrySet().iterator(); i.hasNext();) {
            Map.Entry entry = (Map.Entry) i.next();

            os.writeObject(entry.getKey());
            os.writeObject(entry.getValue());
        }
    }

    /* ============================================================================ */
    /* Ʒ(Clonableӿ)                                                       */
    /* ============================================================================ */

    /**
     * &quot;ǳ&quot;hash, keyvalue.
     *
     * @return Ƶhash.
     */
    public Object clone() {
        DefaultHashMap result = null;

        try {
            result = (DefaultHashMap) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new InternalError(); // ֧clone().
        }

        result.table    = new Entry[table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size     = 0;
        result.onInit();
        result.putAllForCreate(this);

        return result;
    }

    /* ============================================================================ */
    /* ڲ                                                                     */
    /* ============================================================================ */

    /**
     * һʼԼ. ÷й캯Լ&quot;α캯&quot;(<code>clone</code>, <code>readObject</code>).
     * ʱ, hashѱʼ, δ뵽.
     */
    protected void onInit() {
    }

    /**
     * ָkeyӦentry. , 򷵻null.
     *
     * @param key ָkeyӦentry
     *
     * @return ָkeyӦentry
     */
    protected Entry getEntry(Object key) {
        int hash = hash(key);
        int i = indexFor(hash, table.length);

        for (Entry entry = table[i]; entry != null; entry = entry.next) {
            if ((entry.hash == hash) && eq(key, entry.getKey())) {
                return entry;
            }
        }

        return null;
    }

    /**
     * һentryhash, hash<code>resize()</code>. ԸǴ˷, Ըı<code>put</code>,
     * <code>new HashMap(Map)</code>, <code>clone</code>, <code>readObject</code>Ϊ.
     *
     * @param key hashkey
     * @param value hashvalue
     */
    protected void addEntry(Object key, Object value) {
        int hash = hash(key);
        int i = indexFor(hash, table.length);

        table[i] = new Entry(hash, key, value, table[i]);
        size++;
    }

    /**
     * ˷캯&quot;α캯&quot;(clone, readObject), ͬput, resizeımodCount.
     *
     * @param key Ҫkey
     * @param value Ҫkeyvalue
     */
    private void putForCreate(Object key, Object value) {
        Entry entry = getEntry(key);

        if (entry != null) {
            entry.setValue(value);
        } else {
            addEntry(key, value);
        }
    }

    /**
     * һputentry.
     *
     * @param map ָmapentryhash
     */
    private void putAllForCreate(Map map) {
        for (Iterator i = map.entrySet().iterator(); i.hasNext();) {
            Map.Entry entry = (Map.Entry) i.next();

            putForCreate(entry.getKey(), entry.getValue());
        }
    }

    /**
     * ɾָkeyӦentry, رɾentry.
     *
     * @param key Ҫɾentrykey
     *
     * @return ɾentry, entry, 򷵻<code>null</code>
     */
    protected Entry removeEntryForKey(Object key) {
        int   hash  = hash(key);
        int   i     = indexFor(hash, table.length);
        Entry prev  = table[i];
        Entry entry = prev;

        while (entry != null) {
            Entry next = entry.next;

            if ((entry.hash == hash) && eq(key, entry.getKey())) {
                modCount++;
                size--;

                if (prev == entry) {
                    table[i] = next;
                } else {
                    prev.next = next;
                }

                entry.onRemove();

                return entry;
            }

            prev  = entry;
            entry = next;
        }

        return entry;
    }

    /**
     * ɾָentry. <code>EntrySet.remove</code>.
     *
     * @param o Ҫɾentry
     *
     * @return ɾentry
     */
    protected Entry removeEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }

        Map.Entry entry = (Map.Entry) o;
        Object    key  = entry.getKey();
        int       hash = hash(key);
        int       i    = indexFor(hash, table.length);
        Entry     prev = table[i];
        Entry     e    = prev;

        while (e != null) {
            Entry next = e.next;

            if ((e.hash == hash) && e.equals(entry)) {
                modCount++;
                size--;

                if (prev == e) {
                    table[i] = next;
                } else {
                    prev.next = next;
                }

                e.onRemove();

                return e;
            }

            prev = e;
            e    = next;
        }

        return e;
    }

    /**
     * าǴ˷, keyı.
     *
     * @return hashkeyı
     */
    protected Iterator newKeyIterator() {
        return new KeyIterator();
    }

    /**
     * าǴ˷, valueı.
     *
     * @return hashkeyı
     */
    protected Iterator newValueIterator() {
        return new ValueIterator();
    }

    /**
     * าǴ˷, entryı.
     *
     * @return hashkeyı
     */
    protected Iterator newEntryIterator() {
        return new EntryIterator();
    }

    /**
     * ضhashֵ.
     *
     * @param obj ȡָhashֵ
     *
     * @return ָhashֵ
     */
    protected static int hash(Object obj) {
        int h = (obj == null) ? 0
                              : obj.hashCode();

        return h - (h << 7); // Ҳ, -127 * h
    }

    /**
     * Ƚ.
     *
     * @param x һ
     * @param y ڶ
     *
     * @return ͬ, 򷵻<code>true</code>
     */
    protected static boolean eq(Object x, Object y) {
        return (x == null) ? (y == null)
                           : ((x == y) || x.equals(y));
    }

    /**
     * ֵ, ָhashֵĳ.
     *
     * @param hash hashֵ
     * @param length ĳ, Ȼ2
     *
     * @return hashֵе
     */
    protected static int indexFor(int hash, int length) {
        return hash & (length - 1);
    }

    /**
     * map.  ˷entryֵʱ.
     *
     * @param newCapacity µ(Ϊ2).
     */
    protected void resize(int newCapacity) {
        Entry[] oldTable    = table;
        int     oldCapacity = oldTable.length;

        if ((size < threshold) || (oldCapacity > newCapacity)) {
            return;
        }

        Entry[] newTable = new Entry[newCapacity];

        transfer(newTable);
        table     = newTable;
        threshold = (int) (newCapacity * loadFactor);
    }

    /**
     * entryӵǰƵ±().
     *
     * @param newTable ±
     */
    protected void transfer(Entry[] newTable) {
        Entry[] src         = table;
        int     newCapacity = newTable.length;

        for (int j = 0; j < src.length; j++) {
            Entry entry = src[j];

            if (entry != null) {
                src[j] = null;

                do {
                    Entry next = entry.next;
                    int   i = indexFor(entry.hash, newCapacity);

                    entry.next  = newTable[i];
                    newTable[i] = entry;
                    entry       = next;
                } while (entry != null);
            }
        }
    }

    /**
     * ȡhash.
     *
     * @return hash
     */
    protected int getCapacity() {
        return table.length;
    }

    /**
     * ȡhashĸϵ.
     *
     * @return hashĸϵ
     */
    protected float getLoadFactor() {
        return loadFactor;
    }

    /**
     * ȡhashֵ.
     *
     * @return hashֵ
     */
    protected int getThreshold() {
        return threshold;
    }
}