package com.meidusa.toolkit.common.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/**
 * <p>
 * һϵʵ, ʵ<code>Set</code>ӿ.
 * </p>
 *
 * <p>
 * ڲʹ<code>ArrayHashMap</code>漯еԪ, :
 * </p>
 *
 * <ul>
 * <li>
 * ͬ<code>HashMap</code>, Ԫص˳ȷ
 * </li>
 * <li>
 * <code>ArrayHashMap</code>һ, ûнκ<code>synchronized</code>
 * </li>
 * </ul>
 *
 *
 * @version 
 * 
 * @see ArrayHashMap
 */
public class ArrayHashSet extends AbstractSet implements Set, Cloneable, Serializable {
    /* ============================================================================ */
    /*                                                                          */
    /* ============================================================================ */

    /** ʾڲhashֵ. */
    private static final Object PRESENT = new Object();

    /* ============================================================================ */
    /* Ա                                                                     */
    /* ============================================================================ */

    /** ڲhash. */
    protected transient ArrayHashMap map;

    /* ============================================================================ */
    /* 캯                                                                     */
    /* ============================================================================ */

    /**
     * һյļ. ʹָĬϵĳʼ(16)Ĭϵĸϵ(0.75).
     */
    public ArrayHashSet() {
        map = new ArrayHashMap();
    }

    /**
     * һյļ. ʹָĳʼֵĬϵĸϵ(0.75).
     *
     * @param initialCapacity ʼ.
     */
    public ArrayHashSet(int initialCapacity) {
        map = new ArrayHashMap(initialCapacity);
    }

    /**
     * һյļ. ʹָĳʼ͸ϵ.
     *
     * @param initialCapacity ʼ
     * @param loadFactor ϵ.
     */
    public ArrayHashSet(int initialCapacity, float loadFactor) {
        map = new ArrayHashMap(initialCapacity, loadFactor);
    }

    /**
     * һյļ, ָ<code>Collection</code>. ʹĬϵĸϵ(0.75).
     *
     * @param collection ҪƵ<code>Collection</code>
     */
    public ArrayHashSet(Collection collection) {
        map = new ArrayHashMap(Math.max((int) (collection.size() / .75f) + 1, 16));
        addAll(collection);
    }

    /* ============================================================================ */
    /* ʵSetӿڵķ                                                            */
    /* ============================================================================ */

    /**
     * ؼentryĸ.
     *
     * @return еentry.
     */
    public int size() {
        return map.size();
    }

    /**
     * жǷΪյļ.
     *
     * @return Ϊ(<code>size() == 0</code>), 򷵻<code>true</code>.
     */
    public boolean isEmpty() {
        return map.isEmpty();
    }

    /**
     * аֵָ, 򷵻<code>true</code>.
     *
     * @param object   ֵָǷ.
     *
     * @return ֵָ, 򷵻<code>true</code>.
     */
    public boolean contains(Object object) {
        return map.containsKey(object);
    }

    /**
     * ֵָ뵽.
     *
     * @param object Ҫֵ
     *
     * @return Ѿڴֵ, 򷵻<code>false</code>. 򷵻<code>true</code>.
     */
    public boolean add(Object object) {
        return map.put(object, PRESENT) == null;
    }

    /**
     * ֵָӼɾ(ֵڵĻ).
     *
     * @param object Ҫɾֵ
     *
     * @return ɾֵԭ, 򷵻<code>false</code>, 򷵻<code>true</code>
     */
    public boolean remove(Object o) {
        return map.remove(o) == PRESENT;
    }

    /**
     * еж.
     */
    public void clear() {
        map.clear();
    }

    /**
     * ȡüı.
     *
     * @return ı
     */
    public Iterator iterator() {
        return map.keySet().iterator();
    }

    /* ============================================================================ */
    /* Ʒ(Clonableӿ)                                                       */
    /* ============================================================================ */

    /**
     * &quot;ǳ&quot;, еĶ.
     *
     * @return Ƶļ.
     */
    public Object clone() {
        try {
            ArrayHashSet newSet = (ArrayHashSet) super.clone();

            newSet.map = (ArrayHashMap) map.clone();

            return newSet;
        } catch (CloneNotSupportedException e) {
            throw new InternalError(); // ֧clone().
        }
    }

    /* ============================================================================ */
    /* л                                                                       */
    /* ============================================================================ */

    /** л汾. */
    private static final long serialVersionUID = -5024744406713321676L;

    /**
     * ؽ(ҲǷл).
     *
     * @param is 
     *
     * @exception IOException 쳣
     * @exception ClassNotFoundException δҵ
     */
    private synchronized void readObject(ObjectInputStream is) throws IOException,
                                                                      ClassNotFoundException {
        is.defaultReadObject();

        int   capacity   = is.readInt();
        float loadFactor = is.readFloat();

        map = new ArrayHashMap(capacity, loadFactor);

        int size = is.readInt();

        for (int i = 0; i < size; i++) {
            Object e = is.readObject();

            map.put(e, PRESENT);
        }
    }

    /**
     * ϵ״̬浽(Ҳл).
     *
     * @param os 
     *
     * @exception IOException 쳣
     */
    private synchronized void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();

        os.writeInt(map.getCapacity());
        os.writeFloat(map.getLoadFactor());

        os.writeInt(map.size());

        for (Iterator i = map.keySet().iterator(); i.hasNext();) {
            os.writeObject(i.next());
        }
    }
}