package com.meidusa.toolkit.common.util.collection;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

/**
 * <p>
 * һHashʵ, ʵ<code>ListMap</code><code>Map</code>ӿ.
 * </p>
 *
 * <p>
 * hashʵ־:
 * </p>
 *
 * <ul>
 * <li>
 * ڲķʽentry, ˳
 * </li>
 * <li>
 * <code>DefaultHashMap</code>һ, ûнκ<code>synchronized</code>
 * </li>
 * </ul>
 *
 *
 * @version 
 * 
 * @see DefaultHashMap
 * @see ListMap
 */
public class ArrayHashMap extends DefaultHashMap implements ListMap {
    private static final long serialVersionUID = -108097684311309571L;
    
    /* ============================================================================ */
    /* Ա                                                                     */
    /* ============================================================================ */

    /** ¼entry˳. */
    protected transient Entry[] order;

    /** Keyбͼ. */
    private transient List keyList;

    /** Valueбͼ. */
    private transient List valueList;

    /** Entryбͼ. */
    private transient List entryList;

    /* ============================================================================ */
    /* 캯                                                                     */
    /* ============================================================================ */

    /**
     * һյhash. ʹָĬϵĳʼ(16)Ĭϵĸϵ(0.75).
     */
    public ArrayHashMap() {
        super();
    }

    /**
     * һյhash. ʹָĳʼֵĬϵĸϵ(0.75).
     *
     * @param initialCapacity ʼ.
     */
    public ArrayHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    /**
     * һյhash. ʹָĳʼ͸ϵ.
     *
     * @param initialCapacity ʼ
     * @param loadFactor ϵ.
     */
    public ArrayHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    /**
     * ָ<code>Map</code>ͬ<code>HashMap</code>. ʹĬϵĸϵ(0.75).
     *
     * @param map ҪƵ<code>Map</code>
     */
    public ArrayHashMap(Map map) {
        super(map);
    }

    /* ============================================================================ */
    /* ʵMapListMapӿڵķ                                                   */
    /* ============================================================================ */

    /**
     * hashаһkeyӦָvalue, 򷵻true.
     *
     * @param value ָvalue, Ĵ.
     *
     * @return hashаһkeyӦָvalue, 򷵻<code>true</code>.
     */
    public boolean containsValue(Object value) {
        // Ǵ˷ǳܵĿ.  ҸЧ.
        for (int i = 0; i < size; i++) {
            Entry entry = order[i];

            if (eq(value, entry.getValue())) {
                return true;
            }
        }

        return false;
    }

    /**
     * hashеentry.
     */
    public void clear() {
        super.clear();
        Arrays.fill(order, null);
    }

    /**
     * ָindexvalue. indexΧ, <code>IndexOutOfBoundsException</code>.
     *
     * @param index Ҫصvalueֵ
     *
     * @return ָindexvalue
     */
    public Object get(int index) {
        checkRange(index);
        return order[index].getValue();
    }

    /**
     * ָindexkey. indexΧ, <code>IndexOutOfBoundsException</code>.
     *
     * @param index Ҫصkeyֵ
     *
     * @return ָindexkey
     */
    public Object getKey(int index) {
        checkRange(index);
        return order[index].getKey();
    }

    /**
     * ɾָindex. indexΧ, <code>IndexOutOfBoundsException</code>.
     *
     * @param index Ҫɾֵ
     *
     * @return ɾ<code>Map.Entry</code>
     */
    public Map.Entry remove(int index) {
        checkRange(index);
        return removeEntryForKey(order[index].getKey());
    }

    /**
     * key<code>List</code>.
     *
     * @return key<code>List</code>.
     */
    public List keyList() {
        return ((keyList != null) ? keyList
                                  : (keyList = new KeyList()));
    }

    /**
     * value<code>List</code>.
     *
     * @return value<code>List</code>.
     */
    public List valueList() {
        return ((valueList != null) ? valueList
                                    : (valueList = new ValueList()));
    }

    /**
     * entry<code>List</code>.
     *
     * @return entry<code>List</code>.
     */
    public List entryList() {
        return ((entryList != null) ? entryList
                                    : (entryList = new EntryList()));
    }

    /* ============================================================================ */
    /* ڲ                                                                       */
    /* ============================================================================ */

    /**
     * <code>Map.Entry</code>ʵ.
     */
    protected class Entry extends DefaultHashMap.Entry {
        /** Entryбеֵ. */
        protected int index;

        /**
         * һµentry.
         *
         * @param h keyhashֵ
         * @param k entrykey
         * @param v entryvalue
         * @param n еһentry
         */
        protected Entry(int h, Object k, Object v, DefaultHashMap.Entry n) {
            super(h, k, v, n);
        }

        /**
         * entryɾʱ, ºentryֵ.
         */
        protected void onRemove() {
            int numMoved = size - index;

            if (numMoved > 0) {
                System.arraycopy(order, index + 1, order, index, numMoved);
            }

            order[size] = null;

            for (int i = index; i < size; i++) {
                order[i].index--;
            }
        }
    }

    /**
     * .
     */
    private abstract class ArrayHashIterator implements ListIterator {
        /** صentry. */
        private Entry lastReturned;

        /** ǰλ. */
        private int cursor;

        /** iteratorʱ޸ļ. */
        private int expectedModCount;

        /**
         * һlist iterator.
         *
         * @param index ʼ
         *
         * @return list iterator
         */
        protected ArrayHashIterator(int index) {
            if ((index < 0) || (index > size())) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }

            cursor           = index;
            expectedModCount = modCount;
        }

        /**
         * ָ뵽б. (ִ֧˲)
         *
         * @param o ҪĶ
         */
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        /**
         * ָ滻б. (<code>valueList</code>, ִ֧˲)
         *
         * @param o Ҫ滻Ķ
         */
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        /**
         * رǷһentry.
         *
         * @return лһentry, <code>true</code>
         */
        public boolean hasNext() {
            return cursor < size;
        }

        /**
         * رǷǰһentry.
         *
         * @return лǰһentry, <code>true</code>
         */
        public boolean hasPrevious() {
            return cursor > 0;
        }

        /**
         * ȡһindex. һ, 򷵻<code>size</code>.
         *
         * @return һindex
         */
        public int nextIndex() {
            return cursor;
        }

        /**
         * ȡǰһindex. ǵһ, 򷵻<code>-1</code>.
         *
         * @return ǰһindex
         */
        public int previousIndex() {
            return cursor - 1;
        }

        /**
         * ɾһǰentry. ִǰִ<code>next()</code><code>previous()</code>.
         */
        public void remove() {
            if (lastReturned == null) {
                throw new IllegalStateException();
            }

            checkForComodification();

            removeEntryForKey(lastReturned.getKey());

            if (lastReturned.index < cursor) {
                cursor--;
            }

            lastReturned     = null;
            expectedModCount = modCount;
        }

        /**
         * ȡһentry.
         *
         * @return һentry
         */
        protected Entry nextEntry() {
            checkForComodification();

            if (cursor >= size) {
                throw new NoSuchElementException();
            }

            lastReturned = order[cursor++];

            return lastReturned;
        }

        /**
         * ȡǰһentry.
         *
         * @return ǰһentry
         */
        protected Entry previousEntry() {
            checkForComodification();

            if (cursor <= 0) {
                throw new NoSuchElementException();
            }

            lastReturned = order[--cursor];

            return lastReturned;
        }

        /**
         * õǰentryֵ.
         *
         * @param o Ҫõֵ
         */
        protected void setValue(Object o) {
            if (lastReturned == null) {
                throw new IllegalStateException();
            }

            checkForComodification();

            lastReturned.setValue(o);
        }

        /**
         * Ƿͬʱ޸.
         */
        private void checkForComodification() {
            if (modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /**
     * ȡhashkeyı.
     */
    private class KeyIterator extends ArrayHashIterator {
        /**
         * һlist iterator.
         *
         * @param index ʼ
         *
         * @return list iterator
         */
        protected KeyIterator(int index) {
            super(index);
        }

        /**
         * ȡһkey.
         *
         * @return һkey
         */
        public Object next() {
            return nextEntry().getKey();
        }

        /**
         * ȡǰһkey.
         *
         * @return ǰһkey
         */
        public Object previous() {
            return previousEntry().getKey();
        }
    }

    /**
     * ȡhashvalueı.
     */
    private class ValueIterator extends ArrayHashIterator {
        /**
         * һlist iterator.
         *
         * @param index ʼ
         *
         * @return list iterator
         */
        protected ValueIterator(int index) {
            super(index);
        }

        /**
         * ָ滻б.
         *
         * @param o Ҫ滻Ķ(value)
         */
        public void set(Object o) {
            setValue(o);
        }

        /**
         * ȡһvalue.
         *
         * @return һvalue
         */
        public Object next() {
            return nextEntry().getValue();
        }

        /**
         * ȡǰһvalue.
         *
         * @return ǰһvalue
         */
        public Object previous() {
            return previousEntry().getValue();
        }
    }

    /**
     * ȡhashentryı.
     */
    private class EntryIterator extends ArrayHashIterator {
        /**
         * һlist iterator.
         *
         * @param index ʼ
         *
         * @return list iterator
         */
        protected EntryIterator(int index) {
            super(index);
        }

        /**
         * ȡһentry.
         *
         * @return һentry
         */
        public Object next() {
            return nextEntry();
        }

        /**
         * ȡǰһentry.
         *
         * @return ǰһentry
         */
        public Object previous() {
            return previousEntry();
        }
    }

    /**
     * бͼ.
     */
    private abstract class ArrayHashList extends AbstractList {
        /**
         * hashentryĸ.
         *
         * @return hashеentry.
         */
        public int size() {
            return size;
        }

        /**
         * жǷΪյhash.
         *
         * @return Ϊ(<code>size() == 0</code>), 򷵻<code>true</code>.
         */
        public boolean isEmpty() {
            return size == 0;
        }

        /**
         * entry.
         */
        public void clear() {
            ArrayHashMap.this.clear();
        }

        /**
         * ɾָindex. indexΧ, <code>IndexOutOfBoundsException</code>.
         *
         * @param index Ҫɾֵ
         *
         * @return ɾ<code>Map.Entry</code>
         */
        public Object remove(int index) {
            checkRange(index);
            return removeEntryForKey(order[index].getKey());
        }

        /**
         * ȡָentry. ͬ<code>indexOf</code>.
         *
         * @param o Ҫҵentry
         *
         * @return ָentry
         */
        public int lastIndexOf(Object o) {
            return indexOf(o);
        }
    }

    /**
     * entryбͼ.
     */
    private class EntryList extends ArrayHashList {
        /**
         * жentryбǷָ.
         *
         * @param o ҪҵĶ
         *
         * @return entryбǷָ, 򷵻<code>true</code>
         */
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }

            Map.Entry entry     = (Map.Entry) o;
            Entry     candidate = (ArrayHashMap.Entry) getEntry(entry.getKey());

            return eq(candidate, entry);
        }

        /**
         * ȡentryı.
         *
         * @return entryı
         */
        public Iterator iterator() {
            return newEntryIterator();
        }

        /**
         * ɾָentry.
         *
         * @param o Ҫɾentry
         *
         * @return ɾɹ, <code>true</code>
         */
        public boolean remove(Object o) {
            return removeEntry(o) != null;
        }

        /**
         * ָindexentry. indexΧ, <code>IndexOutOfBoundsException</code>.
         *
         * @param index Ҫصentryֵ
         *
         * @return ָindexentry
         */
        public Object get(int index) {
            checkRange(index);
            return order[index];
        }

        /**
         * ȡָentry.
         *
         * @param o Ҫҵentry
         *
         * @return ָentry
         */
        public int indexOf(Object o) {
            if ((o != null) && o instanceof Map.Entry) {
                Entry entry = (Entry) getEntry(((Map.Entry) o).getKey());

                if ((entry != null) && entry.equals(o)) {
                    return entry.index;
                }
            }

            return -1;
        }

        /**
         * ȡlist iterator, õǰλ.
         *
         * @param index ǰλ
         *
         * @return list iterator
         */
        public ListIterator listIterator(int index) {
            return new EntryIterator(index);
        }
    }

    /**
     * keyбͼ.
     */
    private class KeyList extends ArrayHashList {
        /**
         * жkeyбǷָ.
         *
         * @param o ҪҵĶ
         *
         * @return keyбǷָ, 򷵻<code>true</code>
         */
        public boolean contains(Object o) {
            return ArrayHashMap.this.containsKey(o);
        }

        /**
         * ȡkeyı.
         *
         * @return keyı
         */
        public Iterator iterator() {
            return newKeyIterator();
        }

        /**
         * ɾָkey.
         *
         * @param o Ҫɾkey
         *
         * @return ɾɹ, <code>true</code>
         */
        public boolean remove(Object o) {
            Entry entry = (Entry) getEntry(o);

            if (entry == null) {
                return false;
            } else {
                removeEntry(entry);
                return true;
            }
        }

        /**
         * ָindexkey. indexΧ, <code>IndexOutOfBoundsException</code>.
         *
         * @param index Ҫصkeyֵ
         *
         * @return ָindexkey
         */
        public Object get(int index) {
            checkRange(index);
            return order[index].getKey();
        }

        /**
         * ȡָkey.
         *
         * @param o Ҫҵkey
         *
         * @return ָkey
         */
        public int indexOf(Object o) {
            Entry entry = (Entry) getEntry(o);

            if (entry != null) {
                return entry.index;
            }

            return -1;
        }

        /**
         * ȡlist iterator, õǰλ.
         *
         * @param index ǰλ
         *
         * @return list iterator
         */
        public ListIterator listIterator(int index) {
            return new KeyIterator(index);
        }
    }

    /**
     * valueбͼ.
     */
    private class ValueList extends ArrayHashList {
        /**
         * жvalueбǷָ.
         *
         * @param o ҪҵĶ
         *
         * @return valueбǷָ, 򷵻<code>true</code>
         */
        public boolean contains(Object o) {
            return ArrayHashMap.this.containsValue(o);
        }

        /**
         * ȡvalueı.
         *
         * @return valueı
         */
        public Iterator iterator() {
            return newValueIterator();
        }

        /**
         * ɾָvalue.
         *
         * @param o Ҫɾvalue
         *
         * @return ɾɹ, <code>true</code>
         */
        public boolean remove(Object o) {
            int index = indexOf(o);

            if (index != -1) {
                ArrayHashMap.this.remove(index);
                return true;
            }

            return false;
        }

        /**
         * ָindexvalue. indexΧ, <code>IndexOutOfBoundsException</code>.
         *
         * @param index Ҫصvalueֵ
         *
         * @return ָindexvalue
         */
        public Object get(int index) {
            checkRange(index);
            return order[index].getValue();
        }

        /**
         * ȡָvalue.
         *
         * @param o Ҫҵvalue
         *
         * @return ָvalue
         */
        public int indexOf(Object o) {
            for (int i = 0; i < size; i++) {
                if (eq(o, order[i].getValue())) {
                    return i;
                }
            }

            return -1;
        }

        /**
         * ȡlist iterator, õǰλ.
         *
         * @param index ǰλ
         *
         * @return list iterator
         */
        public ListIterator listIterator(int index) {
            return new ValueIterator(index);
        }
    }

    /* ============================================================================ */
    /* ڲ                                                                     */
    /* ============================================================================ */

    /**
     * ʼʱhash.
     */
    protected void onInit() {
        order = new Entry[threshold];
    }

    /**
     * ˷˸ķ.  һentry, ͬʱentry¼orderб.
     *
     * @param key hashkey
     * @param value hashvalue
     */
    protected void addEntry(Object key, Object value) {
        int   hash  = hash(key);
        int   i     = indexFor(hash, table.length);
        Entry entry = new Entry(hash, key, value, table[i]);

        table[i]      = entry;
        entry.index   = size;
        order[size++] = entry;
    }

    /**
     * Ǹķ, keyı.
     *
     * @return hashkeyı
     */
    protected Iterator newKeyIterator() {
        return new KeyIterator(0);
    }

    /**
     * Ǹķ, valueı.
     *
     * @return hashkeyı
     */
    protected Iterator newValueIterator() {
        return new ValueIterator(0);
    }

    /**
     * Ǹķ, entryı.
     *
     * @return hashkeyı
     */
    protected Iterator newEntryIterator() {
        return new EntryIterator(0);
    }

    /**
     * map.  ˷entryֵʱ.
     *
     * @param newCapacity µ
     */
    protected void resize(int newCapacity) {
        super.resize(newCapacity);

        if (threshold > order.length) {
            Entry[] newOrder = new Entry[threshold];

            System.arraycopy(order, 0, newOrder, 0, order.length);

            order = newOrder;
        }
    }

    /**
     * <code>resize</code>ʱô˷еƵµ. Ǵ˷ǳܵĿ, ΪhashԭʵַЧ.
     *
     * @param newTable ±
     */
    protected void transfer(DefaultHashMap.Entry[] newTable) {
        int newCapacity = newTable.length;

        for (int i = 0; i < size; i++) {
            Entry entry = order[i];
            int   index = indexFor(entry.hash, newCapacity);

            entry.next      = newTable[index];
            newTable[index] = entry;
        }
    }

    /**
     * ֵָǷԽ.  , ʱ쳣.
     *
     * @param index Ҫ쳣
     */
    private void checkRange(int index) {
        if ((index >= size) || (index < 0)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }
}