package com.meidusa.toolkit.common.util;

import java.text.*;
import java.util.*;

/**
 * <p>
 * Title: ṩĸʱʽתķ
 * </p>
 * <p>
 * Description: ЩתҲΪjava apiѾṩˣ˵
 * </p>
 * <p>
 * Calendar calendar = Calendar.getInstance();
 * </p>
 * <p>
 * java.util.Date date = calendar.getTime();
 * </p>
 * <p>
 * Copyright: Copyright (c) 2002.6.24
 * </p>
 * <p>
 * Company: wondertek
 * </p>
 * 
 * @author ice
 * @version 1.0
 */

public class TimeTool {
	private static final String FORMAT_TYPE_TIMESTAMP = "yyyy-MM-dd HH:mm:ss";
	private static final String FORMAT_TYPE_DATE = "yyyy-MM-dd";
	private static final String FORMAT_TYPE_TIME = "HH:mm:ss";

	

	public static void main(String[] args) {
		// System.out.println(getYearMonthStr("2003", "9"));
		// int[] yearMonth = addMonth(2003, 0, -11);
		// System.out.println("year = " + yearMonth[0]);
		// System.out.println("month = " + yearMonth[1]);
		System.out
				.println(before(new int[] { 2002, 2 }, new int[] { 2003, 2 }));
	}

	/**
	 * ݿеµõҳʾַswallowרã
	 * 
	 * @param year
	 *            
	 * @param month
	 *            £0-11
	 * @return µַ
	 */
	public static String getYearMonthStr(String year, String month) {
		int intMonth = Integer.parseInt(month) + 1;
		return year + "-" + (intMonth < 10 ? "0" + intMonth : "" + intMonth);
	}

	/**
	 * <p>
	 * õǰʱCalendartime0
	 * </p>
	 * 
	 * @return ǰʱCalendartime0
	 */
	public static Calendar getCalenarDate() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		return calendar;
	}

	/**
	 * жϵһǷСڵڶ
	 * 
	 * @param yearMonth01
	 *            һ
	 * @param yearMonth02
	 *            ڶ
	 * @return true or false
	 */
	public static boolean before(int[] yearMonth01, int[] yearMonth02) {
		return yearMonth01[0] < yearMonth02[0]
				|| yearMonth01[0] == yearMonth02[0]
				&& yearMonth01[1] < yearMonth02[1];
	}

	/**
	 * жϵһǷڵڶ
	 * 
	 * @param yearMonth01
	 *            һ
	 * @param yearMonth02
	 *            ڶ
	 * @return true or false
	 */
	public static boolean after(int[] yearMonth01, int[] yearMonth02) {
		return yearMonth01[0] > yearMonth02[0]
				|| yearMonth01[0] == yearMonth02[0]
				&& yearMonth01[1] > yearMonth02[1];
	}

	/**
	 * жϵһǷڵڶ
	 * 
	 * @param yearMonth01
	 *            һ
	 * @param yearMonth02
	 *            ڶ
	 * @return true or false
	 */
	public static boolean equals(int[] yearMonth01, int[] yearMonth02) {
		return yearMonth01[0] == yearMonth02[0]
				&& yearMonth01[1] == yearMonth02[1];
	}

	/**
	 * жϵһǷڵڶ
	 * 
	 * @param calendar01
	 *            һ
	 * @param calendar02
	 *            ڶ
	 * @return true or false
	 */
	public static boolean equalsYearMonthDay(Calendar calendar01,
			Calendar calendar02) {
		return calendar01.get(Calendar.YEAR) == calendar02.get(Calendar.YEAR)
				&& calendar01.get(Calendar.MONTH) == calendar02
						.get(Calendar.MONTH)
				&& calendar01.get(Calendar.DAY_OF_MONTH) == calendar02
						.get(Calendar.DAY_OF_MONTH);
	}

	/**
	 * <p>
	 * ݲõڵıʾ
	 * </p>
	 * 
	 * @param week
	 *            ڲCalendar.DAY_OF_WEEK1-7ʾյ
	 * @return ڵıʾ
	 */
	public static String getWeekShow(int week) {
		if (week < 1 || week > 7) {
			return null;
		}
		String[] WEEK = { "", "һ", "ڶ", "", "", "", "" };
		return WEEK[week - 1];
	}

	/**
	 * µļӷΪǼ
	 * 
	 * @param yearMonth
	 *            ԭʼ£µķΧ0-11
	 * @param amount
	 *            ӻ߼ٵ£ľǼ
	 */
	public static void addMonth(int[] yearMonth, int amount) {
		int year = yearMonth[0];
		int month = yearMonth[1];
		if (month < 0 || month > 11) {
			throw new IllegalArgumentException(TimeTool.class.getName()
					+ " addMonth month is invaid:month = " + month);
		}
		year += amount / 12;
		month += amount % 12;
		if (month < 0) {
			month += 12;
			year--;
		} else if (month > 11) {
			month -= 12;
			year++;
		}
		yearMonth[0] = year;
		yearMonth[1] = month;
	}

	/**
	 * <p>
	 * ڵ֮
	 * </p>
	 * 
	 * @param calendar1
	 *            1
	 * @param calendar2
	 *            2
	 * @return ڵ֮
	 */
	public static int diffOfDay(Calendar calendar1, Calendar calendar2) {
		long time = diffOfMillis(calendar1, calendar2);
		return (int) (time / (1000 * 60 * 60 * 24));
	}

	/**
	 * <p>
	 * ֵָ֮Ĳ
	 * </p>
	 * 
	 * @param calendar1
	 *            1
	 * @param calendar2
	 *            2
	 * @param field
	 *            Calendarеֵ
	 * @return ֵָ֮Ĳ
	 */
	public static int diffOfField(Calendar calendar1, Calendar calendar2,
			int field) {
		return Math.abs(calendar1.get(field) - calendar2.get(field));
	}

	/**
	 * <p>
	 * ڵĺ֮
	 * </p>
	 * 
	 * @param calendar1
	 *            1
	 * @param calendar2
	 *            2
	 * @return ڵĺ֮
	 */
	public static long diffOfMillis(Calendar calendar1, Calendar calendar2) {
		return Math.abs(calendar1.getTimeInMillis()
				- calendar2.getTimeInMillis());
	}

	/**
	 * <p>
	 * longʱתɡyyyy-mm-dd HH:mm:ssʱʽ
	 * </p>
	 * 
	 * @param time
	 *            long͵ʱ
	 * @return yyyy-mm-ddʱʽ
	 */
	public static String longToStrDateTime(long time) {
		return dateToStrDateTime(new Date(time));
	}

	/**
	 * <p>
	 * longʱתCalendarʽ
	 * </p>
	 * 
	 * @param time
	 *            long͵ʱ
	 * @return Calendarʱʽ
	 */
	public static Calendar longToCalendar(long time) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(time);
		return calendar;
	}

	/**
	 * <p>
	 * yyyy-mm-dd HH:mm:ssʱʽתlongʱ
	 * </p>
	 * 
	 * @param str
	 *            yyyy-mm-ddʱʽ
	 * @return long͵ʱ
	 */
	public static long strDateTimeToLong(String str) {
		return strDateTimeToDate(str).getTime();
	}

	/**
	 * <p>
	 * Calendarʽתlongʱ
	 * </p>
	 * 
	 * @param calendar
	 *            Calendarʱʽ
	 * @return long͵ʱ
	 */
	public static long calendarToLong(Calendar calendar) {
		if (calendar == null) {
			return -1;
		}
		return calendar.getTimeInMillis();
	}

	/**
	 * <p>
	 * õǰʱ䣬yyyy-MM-dd HH:mm:ss
	 * </p>
	 * 
	 * @return ǰʱ
	 */
	public static String getDateTime() {
		return dateToStrDateTime(new Date());
	}

	/**
	 * <p>
	 * õǰʱ䣬yyyy-MM-dd
	 * </p>
	 * 
	 * @return ǰʱ
	 */
	public static String getDate() {
		return dateToStrDate(new Date());
	}

	/**
	 * <p>
	 * õǰʱ䣬HH:mm:ss
	 * </p>
	 * 
	 * @return ǰʱ
	 */
	public static String getTime() {
		return dateToStrTime(new Date());
	}

	/**
	 * <p>
	 * yyyy-MM-dd HH:mm:ssʱʽתDateʽ
	 * </p>
	 * 
	 * @param str
	 *            yyyy-MM-dd HH:mm:ssʱʽ
	 * @return Dateʱʽ
	 */
	public static Date strDateTimeToDate(String str) {
		if (str == null || str.trim().length() == 0) {
			return null;
		}
		if (str.length() == 10) {
			str += " 00:00:00";
		}
		return new SimpleDateFormat(FORMAT_TYPE_TIMESTAMP).parse(str,
				new ParsePosition(0));
	}

	/**
	 * <p>
	 * yyyy-MM-dd HH:mm:ssʱʽתCalendarʽ
	 * </p>
	 * 
	 * @param str
	 *            yyyy-MM-dd HH:mm:ssʱʽ
	 * @return Calendarʱʽ
	 */
	public static Calendar strDateTimeToCalendar(String str) {
		Calendar calendar = Calendar.getInstance();
		Date date = strDateTimeToDate(str);
		if (date == null) {
			return null;
		}
		calendar.setTime(date);
		return calendar;
	}

	/**
	 * <p>
	 * ʱʽתCalendarʽȱĵطԶ0
	 * </p>
	 * 
	 * @param str
	 *            ʱʽ
	 * @return Calendarʱʽ
	 */
	public static Calendar strToCalendar(String str) {
		return strDateTimeToCalendar(str);
	}

	/**
	 * <p>
	 * yyyy-MM-ddʱʽתDateʽ
	 * </p>
	 * 
	 * @param str
	 *            yyyy-MM-ddʱʽ
	 * @return Dateʱʽ
	 */
	public static Date strDateToDate(String str) {
		if (str == null || str.trim().length() == 0) {
			return null;
		}
		if (str.length() == 7) {
			str += "-01 00:00:00";
		}
		return new SimpleDateFormat(FORMAT_TYPE_DATE).parse(str,
				new ParsePosition(0));
	}

	/**
	 * <p>
	 * yyyy-MM-ddʱʽתCalendarʽ
	 * </p>
	 * 
	 * @param str
	 *            yyyy-MM-ddʱʽ
	 * @return Calendarʱʽ
	 */
	public static Calendar strDateToCalendar(String str) {
		Calendar calendar = Calendar.getInstance();
		Date date = strDateToDate(str);
		if (date == null) {
			return null;
		}
		calendar.setTime(date);
		return calendar;
	}

	/**
	 * <p>
	 * Dateתɡyyyy-MM-dd HH:mm:ssʱʽ
	 * </p>
	 * 
	 * @param date
	 *            Dateʽʱ
	 * @return yyyy-MM-dd HH:mm:ssʱʽ
	 */
	public static String dateToStrDateTime(Date date) {
		if (date == null) {
			return null;
		}
		return new SimpleDateFormat(FORMAT_TYPE_TIMESTAMP).format(date);
	}

	/**
	 * <p>
	 * Calendarתɡyyyy-MM-dd HH:mm:ssʱʽ
	 * </p>
	 * 
	 * @param calendar
	 *            Calendarʽʱ
	 * @return yyyy-MM-dd HH:mm:ssʱʽ
	 */
	public static String calendarToStrDateTime(Calendar calendar) {
		if (calendar == null) {
			return null;
		}
		return dateToStrDateTime(calendar.getTime());
	}

	/**
	 * <p>
	 * Dateתɡyyyy-MM-ddʱʽ
	 * </p>
	 * 
	 * @param date
	 *            Dateʽʱ
	 * @return yyyy-MM-ddʱʽ
	 */
	public static String dateToStrDate(Date date) {
		if (date == null) {
			return null;
		}
		return new SimpleDateFormat(FORMAT_TYPE_DATE).format(date);
	}

	/**
	 * <p>
	 * Calendarתɡyyyy-MM-ddʱʽ
	 * </p>
	 * 
	 * @param calendar
	 *            Calendarʽʱ
	 * @return yyyy-MM-ddʱʽ
	 */
	public static String calendarToStrDate(Calendar calendar) {
		if (calendar == null) {
			return null;
		}
		return dateToStrDate(calendar.getTime());
	}

	/**
	 * <p>
	 * DateתɡHH:mm:ssʱʽ
	 * </p>
	 * 
	 * @param date
	 *            Dateʽʱ
	 * @return HH:mm:ssʱʽ
	 */
	public static String dateToStrTime(Date date) {
		if (date == null) {
			return null;
		}
		return new SimpleDateFormat(FORMAT_TYPE_TIME).format(date);
	}

	/**
	 * <p>
	 * CalendarתɡHH:mm:ssʱʽ
	 * </p>
	 * 
	 * @param calendar
	 *            Calendarʽʱ
	 * @return HH:mm:ssʱʽ
	 */
	public static String calendarToStrTime(Calendar calendar) {
		if (calendar == null) {
			return null;
		}
		return dateToStrTime(calendar.getTime());
	}
}