/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.security;

import com.meidusa.toolkit.common.security.BaseSymmetricEncrypt;
import com.meidusa.toolkit.common.security.SymmetricEncrypt;
import com.meidusa.toolkit.common.util.Base64;
import com.meidusa.toolkit.common.util.SoftCache;
import com.meidusa.toolkit.common.util.encode.Hex;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class SymmetricEncryptFactory {
    private static SoftCache cache = new SoftCache();

    private SymmetricEncryptFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SymmetricEncrypt getEncryption(SymmetricEncrypt.SymmetricAlgorithm algorithm, String seed) throws Exception {
        SymmetricEncrypt encrypt = (SymmetricEncrypt)cache.get((Object)(algorithm.hashCode() ^ seed.hashCode()));
        if (encrypt == null) {
            SoftCache softCache = cache;
            synchronized (softCache) {
                if (encrypt == null) {
                    encrypt = new BaseSymmetricEncrypt(algorithm, seed);
                    cache.put((Object)(algorithm.hashCode() ^ seed.hashCode()), (Object)encrypt);
                }
            }
        }
        return encrypt;
    }

    public static String encryptWithHex(SymmetricEncrypt.SymmetricAlgorithm algorithm, String value, String encryptKey) throws Exception {
        SymmetricEncrypt encrypt = SymmetricEncryptFactory.getEncryption(algorithm, encryptKey);
        byte[] byts = encrypt.encrypt(value.getBytes("utf-8"));
        ByteArrayOutputStream btyos = new ByteArrayOutputStream();
        Hex.encode((byte[])byts, (int)0, (int)byts.length, (OutputStream)btyos);
        return btyos.toString();
    }

    public static String decryptWithHex(SymmetricEncrypt.SymmetricAlgorithm algorithm, String hexValue, String encryptKey) throws Exception {
        SymmetricEncrypt encrypt = SymmetricEncryptFactory.getEncryption(algorithm, encryptKey);
        byte[] byts = encrypt.decrypt(Hex.decode((String)hexValue));
        return new String(byts, "utf-8");
    }

    public static String encryptWithBase64(SymmetricEncrypt.SymmetricAlgorithm algorithm, String value, String encryptKey) throws Exception {
        SymmetricEncrypt encrypt = SymmetricEncryptFactory.getEncryption(algorithm, encryptKey);
        byte[] byts = encrypt.encrypt(value.getBytes("utf-8"));
        return Base64.encode((byte[])byts);
    }

    public static String decryptWithBase64(SymmetricEncrypt.SymmetricAlgorithm algorithm, String base64Value, String encryptKey) throws Exception {
        SymmetricEncrypt encrypt = SymmetricEncryptFactory.getEncryption(algorithm, encryptKey);
        byte[] byts = encrypt.decrypt(Base64.decode((String)base64Value));
        return new String(byts, "utf-8");
    }

    public static void main(String[] args) throws Exception {
        String key = "hi..ww..hi..ww..hi..ww..";
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            String encrypted = SymmetricEncryptFactory.encryptWithHex(SymmetricEncrypt.SymmetricAlgorithm.DESede, "\u963f\u65af\u987f\u6cd5e\u963f\u65af\u987f\u6cd5eeeh", key);
            System.out.println(encrypted);
            String decrypt = SymmetricEncryptFactory.decryptWithHex(SymmetricEncrypt.SymmetricAlgorithm.DESede, encrypted, key);
            System.out.println(decrypt);
        }
        System.out.println(System.currentTimeMillis() - start);
    }
}

