package com.meidusa.toolkit.common.security;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

import com.meidusa.toolkit.common.security.SymmetricEncrypt.SymmetricAlgorithm;
import com.meidusa.toolkit.common.util.Base64;
import com.meidusa.toolkit.common.util.SoftCache;
import com.meidusa.toolkit.common.util.encode.Hex;

/**
 * ԳƼ㷨
 * @author Struct
 *
 */
public class SymmetricEncryptFactory {
	private SymmetricEncryptFactory(){};
	private static SoftCache cache = new SoftCache();
	public static SymmetricEncrypt getEncryption(SymmetricAlgorithm algorithm,String seed) throws Exception{
		SymmetricEncrypt encrypt = (SymmetricEncrypt)cache.get(algorithm.hashCode()^seed.hashCode());
		if(encrypt == null){
			synchronized (cache) {
				if(encrypt == null){
					encrypt = new BaseSymmetricEncrypt(algorithm,seed);
					cache.put(algorithm.hashCode()^seed.hashCode(), encrypt);
				}
			}
		}
		return encrypt;
	}
	
	/**
	 * 
	 * @param value
	 * @return
	 * @throws NoSuchAlgorithmException 
	 * @throws UnsupportedEncodingException 
	 */
	public static String encryptWithHex(SymmetricAlgorithm algorithm, String value,String encryptKey) throws Exception{
		SymmetricEncrypt encrypt =  SymmetricEncryptFactory.getEncryption(algorithm, encryptKey);
		byte[] byts = encrypt.encrypt(value.getBytes("utf-8"));
		ByteArrayOutputStream btyos = new ByteArrayOutputStream();
		Hex.encode(byts, 0, byts.length, btyos);
		return btyos.toString();
	}
	
	public static String decryptWithHex(SymmetricAlgorithm algorithm, String hexValue,String encryptKey) throws Exception{
		SymmetricEncrypt encrypt =  SymmetricEncryptFactory.getEncryption(algorithm, encryptKey);
		byte[] byts = encrypt.decrypt(Hex.decode(hexValue));
        return new String(byts,"utf-8");
	}
	
	/**
	 * 
	 * @param value
	 * @return
	 * @throws NoSuchAlgorithmException 
	 * @throws UnsupportedEncodingException 
	 */
	public static String encryptWithBase64(SymmetricAlgorithm algorithm, String value,String encryptKey) throws Exception{
		SymmetricEncrypt encrypt =  SymmetricEncryptFactory.getEncryption(algorithm, encryptKey);
		byte[] byts = encrypt.encrypt(value.getBytes("utf-8"));
		return Base64.encode(byts);
	}
	
	public static String decryptWithBase64(SymmetricAlgorithm algorithm, String base64Value,String encryptKey) throws Exception{
		SymmetricEncrypt encrypt =  SymmetricEncryptFactory.getEncryption(algorithm, encryptKey);
		byte[] byts = encrypt.decrypt(Base64.decode(base64Value));
        return new String(byts,"utf-8");
	}
	
	public static void main(String[] args) throws Exception {
		String key = "hi..ww..hi..ww..hi..ww..";
		long start = System.currentTimeMillis();
		for(int i=0;i<1;i++){
			String encrypted = encryptWithHex(SymmetricEncrypt.SymmetricAlgorithm.DESede,"˹ٷe˹ٷeeeh",key);
			System.out.println(encrypted);
			String decrypt = decryptWithHex(SymmetricEncrypt.SymmetricAlgorithm.DESede,encrypted,key);
			System.out.println(decrypt);
		}
		System.out.println(System.currentTimeMillis()-start);
    }
}
