/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.poolable;

import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.heartbeat.HeartbeatManager;
import com.meidusa.toolkit.common.heartbeat.Status;
import com.meidusa.toolkit.common.poolable.ObjectPool;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.PoolableObjectFactory;

public class GenericObjectPool
extends org.apache.commons.pool.impl.GenericObjectPool
implements ObjectPool,
Initialisable {
    private boolean isValid = true;
    private boolean enable;
    private String name;
    private GenericHeartbeatDelayed delay = new GenericHeartbeatDelayed(3L, TimeUnit.SECONDS, this);

    public GenericObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        super(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, -1L);
    }

    public GenericObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle, long softMinEvictableIdleTimeMillis) {
        super(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, minIdle, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle, softMinEvictableIdleTimeMillis, true);
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public void setEnable(boolean isEnabled) {
        this.enable = isEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Object borrowObject() throws Exception {
        if (!this.isValid && this.getNumActive() > 0 && this.getNumIdle() == 0) {
            throw new NoSuchElementException("poolName=" + this.name + ", pool is invalid");
        }
        try {
            return super.borrowObject();
        }
        catch (Exception e) {
            this.isValid = false;
            throw e;
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public void init() {
        HeartbeatManager.addHeartbeat(this.delay);
    }

    public void close() throws Exception {
        HeartbeatManager.removeHeartbeat(this.delay);
        super.close();
    }

    @Override
    public boolean validate() {
        Object object = null;
        try {
            object = super.borrowObject();
            this.setValid(true);
            return true;
        }
        catch (Exception e) {
            if (object != null) {
                try {
                    this.invalidateObject(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = null;
            }
            this.setValid(false);
            return false;
        }
        finally {
            if (object != null) {
                try {
                    this.returnObject(object);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class GenericHeartbeatDelayed
    extends ObjectPool.ObjectPoolHeartbeatDelayed {
        public GenericHeartbeatDelayed(long nsTime, TimeUnit timeUnit, ObjectPool pool) {
            super(nsTime, timeUnit, pool);
        }

        @Override
        public Status doCheck() {
            return super.doCheck();
        }

        @Override
        public boolean isCycle() {
            return true;
        }
    }
}

