/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.bean.util;

import java.lang.reflect.Field;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;

public class JVM {
    private Map loaderCache = new HashMap();
    private static final boolean reverseFieldOrder;
    private static final float majorJavaVersion;
    static final float DEFAULT_JAVA_VERSION = 1.3f;

    public static final float getMajorJavaVersion(String javaVersion) {
        try {
            return Float.parseFloat(javaVersion.substring(0, 3));
        }
        catch (NumberFormatException e) {
            return 1.3f;
        }
    }

    public static boolean is14() {
        return majorJavaVersion >= 1.4f;
    }

    public static boolean is15() {
        return majorJavaVersion >= 1.5f;
    }

    public static boolean is16() {
        return majorJavaVersion >= 1.6f;
    }

    private static boolean isSun() {
        return System.getProperty("java.vm.vendor").indexOf("Sun") != -1;
    }

    private static boolean isApple() {
        return System.getProperty("java.vm.vendor").indexOf("Apple") != -1;
    }

    private static boolean isHPUX() {
        return System.getProperty("java.vm.vendor").indexOf("Hewlett-Packard Company") != -1;
    }

    private static boolean isIBM() {
        return System.getProperty("java.vm.vendor").indexOf("IBM") != -1;
    }

    private static boolean isBlackdown() {
        return System.getProperty("java.vm.vendor").indexOf("Blackdown") != -1;
    }

    private static boolean isBEAWithUnsafeSupport() {
        if (System.getProperty("java.vm.vendor").indexOf("BEA") != -1) {
            String vmVersion = System.getProperty("java.vm.version");
            if (vmVersion.startsWith("R")) {
                return true;
            }
            String vmInfo = System.getProperty("java.vm.info");
            if (vmInfo != null) {
                return vmInfo.startsWith("R25.1") || vmInfo.startsWith("R25.2");
            }
        }
        return false;
    }

    public Class loadClass(String name) {
        try {
            Class<?> clazz = (Class<?>)this.loaderCache.get(name);
            if (clazz == null) {
                clazz = Class.forName(name, false, this.getClass().getClassLoader());
                this.loaderCache.put(name, clazz);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private boolean canUseSun14ReflectionProvider() {
        return (JVM.isSun() || JVM.isApple() || JVM.isHPUX() || JVM.isIBM() || JVM.isBlackdown() || JVM.isBEAWithUnsafeSupport()) && JVM.is14() && this.loadClass("sun.misc.Unsafe") != null;
    }

    public static boolean reverseFieldDefinition() {
        return reverseFieldOrder;
    }

    public static void main(String[] args) {
        System.out.println(majorJavaVersion);
    }

    static {
        majorJavaVersion = JVM.getMajorJavaVersion(System.getProperty("java.specification.version"));
        boolean reverse = false;
        Field[] fields = AttributedString.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("text")) continue;
            reverse = i > 3;
        }
        reverseFieldOrder = reverse;
    }
}

