/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.bean.config;

import com.meidusa.toolkit.common.bean.config.BeanObjectEntityConfig;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.toolkit.common.util.StringUtil;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentUtil {
    public static Element getTheOnlyElement(Element current, String tagName) {
        NodeList nodeList = current.getElementsByTagName(tagName);
        if (nodeList.getLength() > 1) {
            throw new ConfigurationException(tagName + " elements length  over one!");
        }
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public static BeanObjectEntityConfig loadBeanConfig(Element current) {
        BeanObjectEntityConfig beanConfig = new BeanObjectEntityConfig();
        return DocumentUtil.loadBeanConfig(current, beanConfig);
    }

    public static BeanObjectEntityConfig loadBeanConfig(Element current, BeanObjectEntityConfig beanConfig) {
        if (current == null) {
            return null;
        }
        NodeList children = current.getChildNodes();
        int childSize = children.getLength();
        beanConfig.setName(current.getAttribute("name"));
        Element element = DocumentUtil.getTheOnlyElement(current, "className");
        if (element != null) {
            String className = element.getTextContent().trim();
            try {
                Class<?> beanClass = Class.forName(className);
                beanConfig.setBeanClass(beanClass);
            }
            catch (Exception e) {
                throw new ConfigurationException("className=" + className + "  not found!");
            }
        }
        if (!StringUtil.isEmpty((String)current.getAttribute("class"))) {
            String className = current.getAttribute("class").trim();
            try {
                Class<?> beanClass = Class.forName(current.getAttribute("class").trim());
                beanConfig.setBeanClass(beanClass);
            }
            catch (Exception e) {
                throw new ConfigurationException("className=" + className + "  not found!");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < childSize; ++i) {
            Element child;
            String nodeName;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element) || !(nodeName = (child = (Element)childNode).getNodeName()).equals("property")) continue;
            String key = child.getAttribute("name");
            NodeList propertyNodes = child.getElementsByTagName("bean");
            if (propertyNodes.getLength() == 0) {
                String value = child.getTextContent();
                map.put(key, StringUtil.isEmpty((String)value) ? null : value.trim());
                continue;
            }
            BeanObjectEntityConfig beanconfig = DocumentUtil.loadBeanConfig((Element)propertyNodes.item(0));
            map.put(key, beanconfig);
        }
        beanConfig.setParams(map);
        return beanConfig;
    }
}

