/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.DefaultRequestPath;
import org.springframework.http.server.reactive.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultServerHttpRequestBuilder
implements ServerHttpRequest.Builder {
    private final ServerHttpRequest delegate;
    @Nullable
    private HttpMethod httpMethod;
    @Nullable
    private String path;
    @Nullable
    private String contextPath;
    @Nullable
    private HttpHeaders httpHeaders;

    public DefaultServerHttpRequestBuilder(ServerHttpRequest delegate) {
        Assert.notNull((Object)delegate, (String)"ServerHttpRequest delegate is required");
        this.delegate = delegate;
    }

    @Override
    public ServerHttpRequest.Builder method(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @Override
    public ServerHttpRequest.Builder path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public ServerHttpRequest.Builder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public ServerHttpRequest.Builder header(String key, String value) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new HttpHeaders();
        }
        this.httpHeaders.add(key, value);
        return this;
    }

    @Override
    public ServerHttpRequest build() {
        URI uriToUse = this.getUriToUse();
        RequestPath path = this.getRequestPathToUse(uriToUse);
        HttpHeaders headers = this.getHeadersToUse();
        return new MutativeDecorator(this.delegate, this.httpMethod, uriToUse, path, headers);
    }

    @Nullable
    private URI getUriToUse() {
        if (this.path == null) {
            return null;
        }
        URI uri = this.delegate.getURI();
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), this.path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Invalid URI path: \"" + this.path + "\"");
        }
    }

    @Nullable
    private RequestPath getRequestPathToUse(@Nullable URI uriToUse) {
        if (uriToUse == null && this.contextPath == null) {
            return null;
        }
        if (uriToUse == null) {
            return new DefaultRequestPath(this.delegate.getPath(), this.contextPath);
        }
        return RequestPath.parse(uriToUse, this.contextPath);
    }

    @Nullable
    private HttpHeaders getHeadersToUse() {
        if (this.httpHeaders != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map<? extends String, ? extends List<String>>)((Object)this.delegate.getHeaders()));
            headers.putAll((Map<? extends String, ? extends List<String>>)((Object)this.httpHeaders));
            return headers;
        }
        return null;
    }

    private static class MutativeDecorator
    extends ServerHttpRequestDecorator {
        @Nullable
        private final HttpMethod httpMethod;
        @Nullable
        private final URI uri;
        @Nullable
        private final RequestPath requestPath;
        @Nullable
        private final HttpHeaders httpHeaders;

        public MutativeDecorator(ServerHttpRequest delegate, @Nullable HttpMethod method, @Nullable URI uri, @Nullable RequestPath requestPath, @Nullable HttpHeaders httpHeaders) {
            super(delegate);
            this.httpMethod = method;
            this.uri = uri;
            this.requestPath = requestPath;
            this.httpHeaders = httpHeaders;
        }

        @Override
        public HttpMethod getMethod() {
            return this.httpMethod != null ? this.httpMethod : super.getMethod();
        }

        @Override
        public URI getURI() {
            return this.uri != null ? this.uri : super.getURI();
        }

        @Override
        public RequestPath getPath() {
            return this.requestPath != null ? this.requestPath : super.getPath();
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.httpHeaders != null ? this.httpHeaders : super.getHeaders();
        }
    }
}

