/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.List;
import java.util.Map;
import org.springframework.social.twitter.api.AccountSettings;
import org.springframework.social.twitter.api.RateLimitStatus;
import org.springframework.social.twitter.api.ResourceFamily;
import org.springframework.social.twitter.api.SuggestionCategory;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.UserOperations;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.AccountSettingsData;
import org.springframework.social.twitter.api.impl.ArrayUtils;
import org.springframework.social.twitter.api.impl.PagingUtils;
import org.springframework.social.twitter.api.impl.RateLimitStatusHolder;
import org.springframework.social.twitter.api.impl.SuggestionCategoryList;
import org.springframework.social.twitter.api.impl.TwitterProfileList;
import org.springframework.social.twitter.api.impl.TwitterProfileUsersList;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

class UserTemplate
extends AbstractTwitterOperations
implements UserOperations {
    private final RestTemplate restTemplate;

    public UserTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser, boolean isAuthorizedForApp) {
        super(isAuthorizedForUser, isAuthorizedForApp);
        this.restTemplate = restTemplate;
    }

    @Override
    public long getProfileId() {
        this.requireUserAuthorization();
        return this.getUserProfile().getId();
    }

    @Override
    public String getScreenName() {
        this.requireUserAuthorization();
        return this.getUserProfile().getScreenName();
    }

    @Override
    public TwitterProfile getUserProfile() {
        this.requireUserAuthorization();
        return (TwitterProfile)this.restTemplate.getForObject(this.buildUri("account/verify_credentials.json"), TwitterProfile.class);
    }

    @Override
    public TwitterProfile getUserProfile(String screenName) {
        this.requireEitherUserOrAppAuthorization();
        return (TwitterProfile)this.restTemplate.getForObject(this.buildUri("users/show.json", "screen_name", screenName), TwitterProfile.class);
    }

    @Override
    public TwitterProfile getUserProfile(long userId) {
        this.requireEitherUserOrAppAuthorization();
        return (TwitterProfile)this.restTemplate.getForObject(this.buildUri("users/show.json", "user_id", String.valueOf(userId)), TwitterProfile.class);
    }

    @Override
    public List<TwitterProfile> getUsers(long ... userIds) {
        this.requireEitherUserOrAppAuthorization();
        String joinedIds = ArrayUtils.join(userIds);
        return (List)this.restTemplate.getForObject(this.buildUri("users/lookup.json", "user_id", joinedIds), TwitterProfileList.class);
    }

    @Override
    public List<TwitterProfile> getUsers(String ... screenNames) {
        this.requireEitherUserOrAppAuthorization();
        String joinedScreenNames = ArrayUtils.join(screenNames);
        return (List)this.restTemplate.getForObject(this.buildUri("users/lookup.json", "screen_name", joinedScreenNames), TwitterProfileList.class);
    }

    @Override
    public List<TwitterProfile> searchForUsers(String query) {
        return this.searchForUsers(query, 1, 20);
    }

    @Override
    public List<TwitterProfile> searchForUsers(String query, int page, int pageSize) {
        this.requireUserAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, 0L, 0L);
        parameters.set((Object)"q", (Object)query);
        return (List)this.restTemplate.getForObject(this.buildUri("users/search.json", parameters), TwitterProfileList.class);
    }

    @Override
    public List<SuggestionCategory> getSuggestionCategories() {
        this.requireEitherUserOrAppAuthorization();
        return (List)this.restTemplate.getForObject(this.buildUri("users/suggestions.json"), SuggestionCategoryList.class);
    }

    @Override
    public List<TwitterProfile> getSuggestions(String slug) {
        this.requireEitherUserOrAppAuthorization();
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("users/suggestions/" + slug + ".json"), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public Map<ResourceFamily, List<RateLimitStatus>> getRateLimitStatus(ResourceFamily ... resources) {
        this.requireEitherUserOrAppAuthorization();
        String joinedResources = ArrayUtils.join((Object[])resources);
        return ((RateLimitStatusHolder)this.restTemplate.getForObject(this.buildUri("application/rate_limit_status.json", "resources", joinedResources), RateLimitStatusHolder.class)).getRateLimits();
    }

    @Override
    public AccountSettings getAccountSettings() {
        this.requireUserAuthorization();
        return (AccountSettings)this.restTemplate.getForObject(this.buildUri("account/settings.json"), AccountSettings.class);
    }

    @Override
    public AccountSettings updateAccountSettings(AccountSettingsData accountSettingsData) {
        this.requireUserAuthorization();
        return (AccountSettings)this.restTemplate.postForObject(this.buildUri("account/settings.json"), accountSettingsData.toRequestParameters(), AccountSettings.class);
    }
}

