/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.springframework.social.twitter.api.Place;
import org.springframework.social.twitter.api.impl.SimilarPlacesResponse;
import org.springframework.social.twitter.api.impl.TwitterModule;

class SimilarPlacesDeserializer
extends JsonDeserializer<SimilarPlacesResponse> {
    SimilarPlacesDeserializer() {
    }

    public SimilarPlacesResponse deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new TwitterModule());
        jp.setCodec((ObjectCodec)mapper);
        JsonNode node = (JsonNode)jp.readValueAs(JsonNode.class);
        JsonNode resultNode = node.get("result");
        String token = resultNode.get("token").textValue();
        JsonNode placesNode = resultNode.get("places");
        List places = (List)mapper.readerFor((TypeReference)new TypeReference<List<Place>>(){}).readValue(placesNode);
        return new SimilarPlacesResponse(places, token);
    }
}

