/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.social.twitter.api.RateLimitStatus;
import org.springframework.social.twitter.api.ResourceFamily;
import org.springframework.social.twitter.api.impl.RateLimitStatusHolder;

public class RateLimitStatusDeserializer
extends JsonDeserializer<RateLimitStatusHolder> {
    public RateLimitStatusHolder deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.readValueAs(JsonNode.class);
        if (null == node || node.isMissingNode() || node.isNull()) {
            return null;
        }
        JsonNode resources = node.get("resources");
        EnumMap<ResourceFamily, List<RateLimitStatus>> rateLimits = new EnumMap<ResourceFamily, List<RateLimitStatus>>(ResourceFamily.class);
        Iterator resourceFamilyIt = resources.fields();
        while (resourceFamilyIt.hasNext()) {
            Map.Entry resourceFamilyNode = (Map.Entry)resourceFamilyIt.next();
            LinkedList<RateLimitStatus> rateLimitsList = new LinkedList<RateLimitStatus>();
            Iterator resourceEndpointIt = ((JsonNode)resourceFamilyNode.getValue()).fields();
            while (resourceEndpointIt.hasNext()) {
                Map.Entry endpointNode = (Map.Entry)resourceEndpointIt.next();
                RateLimitStatus endpointLimit = new RateLimitStatus((String)endpointNode.getKey(), ((JsonNode)endpointNode.getValue()).get("limit").asInt(), ((JsonNode)endpointNode.getValue()).get("remaining").asInt(), ((JsonNode)endpointNode.getValue()).get("reset").asInt());
                rateLimitsList.add(endpointLimit);
            }
            rateLimits.put(ResourceFamily.getResourceFamily((String)resourceFamilyNode.getKey()), rateLimitsList);
        }
        return new RateLimitStatusHolder(rateLimits);
    }
}

