/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.springframework.social.twitter.api.Trend;
import org.springframework.social.twitter.api.Trends;
import org.springframework.social.twitter.api.impl.LocalTrendsHolder;

class LocalTrendsDeserializer
extends JsonDeserializer<LocalTrendsHolder> {
    private static final String LOCAL_TREND_DATE_FORMAT = "yyyy-mm-dd'T'HH:mm:ss'Z'";

    LocalTrendsDeserializer() {
    }

    public LocalTrendsHolder deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.readValueAs(JsonNode.class);
        Iterator dayIt = node.iterator();
        if (dayIt.hasNext()) {
            JsonNode day = (JsonNode)dayIt.next();
            Date createdAt = LocalTrendsDeserializer.toDate(day.get("created_at").asText());
            JsonNode trendNodes = day.get("trends");
            ArrayList<Trend> trends = new ArrayList<Trend>();
            for (JsonNode trendNode : trendNodes) {
                trends.add(new Trend(trendNode.get("name").asText(), trendNode.get("query").asText()));
            }
            jp.skipChildren();
            return new LocalTrendsHolder(new Trends(createdAt, trends));
        }
        throw new JsonMappingException((Closeable)jp, "Processing " + LocalTrendsHolder.class.getName());
    }

    private static Date toDate(String dateString) {
        try {
            return new SimpleDateFormat(LOCAL_TREND_DATE_FORMAT).parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

