/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api;

import java.util.HashMap;
import java.util.Map;

public enum ResourceFamily {
    ACCOUNT("account"),
    APPLICATION("application"),
    BLOCKS("blocks"),
    DIRECT_MESSAGES("direct_messages"),
    FOLLOWERS("followers"),
    FRIENDS("friends"),
    FRIENDSHIPS("friendships"),
    GEO("geo"),
    HELP("help"),
    LISTS("lists"),
    SAVED_SEARCHES("saved_searches"),
    SEARCH("search"),
    STATUSES("statuses"),
    TRENDS("trends"),
    USERS("users");

    private final String name;
    private static final Map<String, ResourceFamily> stringToEnum;

    private ResourceFamily(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static ResourceFamily getResourceFamily(String name) {
        return stringToEnum.get(name);
    }

    static {
        stringToEnum = new HashMap<String, ResourceFamily>();
        for (ResourceFamily resource : ResourceFamily.values()) {
            stringToEnum.put(resource.toString(), resource);
        }
    }
}

