/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.mapping;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.context.KeyValueMappingContext;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.convert.MappingConfiguration;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.core.index.IndexConfiguration;
import org.springframework.data.redis.core.mapping.BasicRedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RedisMappingContext
extends KeyValueMappingContext<RedisPersistentEntity<?>, RedisPersistentProperty> {
    private static final SimpleTypeHolder SIMPLE_TYPE_HOLDER = new RedisCustomConversions().getSimpleTypeHolder();
    private final MappingConfiguration mappingConfiguration;
    private final TimeToLiveAccessor timeToLiveAccessor;
    private KeySpaceResolver fallbackKeySpaceResolver;

    public RedisMappingContext() {
        this(new MappingConfiguration(new IndexConfiguration(), new KeyspaceConfiguration()));
    }

    public RedisMappingContext(MappingConfiguration mappingConfiguration) {
        this.mappingConfiguration = mappingConfiguration != null ? mappingConfiguration : new MappingConfiguration(new IndexConfiguration(), new KeyspaceConfiguration());
        this.setFallbackKeySpaceResolver(new ConfigAwareKeySpaceResolver(this.mappingConfiguration.getKeyspaceConfiguration()));
        this.timeToLiveAccessor = new ConfigAwareTimeToLiveAccessor(this.mappingConfiguration.getKeyspaceConfiguration(), this);
        this.setSimpleTypeHolder(SIMPLE_TYPE_HOLDER);
    }

    public void setFallbackKeySpaceResolver(KeySpaceResolver fallbackKeySpaceResolver) {
        this.fallbackKeySpaceResolver = fallbackKeySpaceResolver;
    }

    protected <T> RedisPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new BasicRedisPersistentEntity<T>(typeInformation, this.fallbackKeySpaceResolver, this.timeToLiveAccessor);
    }

    protected RedisPersistentProperty createPersistentProperty(Property property, RedisPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new RedisPersistentProperty(property, (PersistentEntity<?, RedisPersistentProperty>)owner, simpleTypeHolder);
    }

    public MappingConfiguration getMappingConfiguration() {
        return this.mappingConfiguration;
    }

    static class ConfigAwareTimeToLiveAccessor
    implements TimeToLiveAccessor {
        private final Map<Class<?>, Long> defaultTimeouts;
        private final Map<Class<?>, PersistentProperty<?>> timeoutProperties;
        private final Map<Class<?>, Method> timeoutMethods;
        private final KeyspaceConfiguration keyspaceConfig;
        private final RedisMappingContext mappingContext;

        ConfigAwareTimeToLiveAccessor(KeyspaceConfiguration keyspaceConfig, RedisMappingContext mappingContext) {
            Assert.notNull((Object)keyspaceConfig, (String)"KeyspaceConfiguration must not be null!");
            Assert.notNull((Object)((Object)mappingContext), (String)"MappingContext must not be null!");
            this.defaultTimeouts = new HashMap();
            this.timeoutProperties = new HashMap();
            this.timeoutMethods = new HashMap();
            this.keyspaceConfig = keyspaceConfig;
            this.mappingContext = mappingContext;
        }

        @Override
        public Long getTimeToLive(Object source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            Class<?> type = source instanceof Class ? (Class<?>)source : (source instanceof PartialUpdate ? ((PartialUpdate)source).getTarget() : source.getClass());
            Long defaultTimeout = this.resolveDefaultTimeOut(type);
            TimeUnit unit = TimeUnit.SECONDS;
            PersistentProperty<?> ttlProperty = this.resolveTtlProperty(type);
            if (ttlProperty != null && ttlProperty.findAnnotation(TimeToLive.class).isPresent()) {
                unit = ((TimeToLive)ttlProperty.findAnnotation(TimeToLive.class).get()).unit();
            }
            if (source instanceof PartialUpdate) {
                PartialUpdate update = (PartialUpdate)source;
                if (ttlProperty != null && !update.getPropertyUpdates().isEmpty()) {
                    for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
                        if (!PartialUpdate.UpdateCommand.SET.equals((Object)pUpdate.getCmd()) || !ttlProperty.getName().equals(pUpdate.getPropertyPath())) continue;
                        return TimeUnit.SECONDS.convert((Long)NumberUtils.convertNumberToTargetClass((Number)((Number)pUpdate.getValue()), Long.class), unit);
                    }
                }
            } else if (ttlProperty != null) {
                RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getPersistentEntity(type).get();
                Optional ttlPropertyValue = entity.getPropertyAccessor(source).getProperty(ttlProperty);
                if (ttlPropertyValue.isPresent()) {
                    return TimeUnit.SECONDS.convert(((Number)ttlPropertyValue.get()).longValue(), unit);
                }
            } else {
                Method timeoutMethod = this.resolveTimeMethod(type);
                if (timeoutMethod != null) {
                    TimeToLive ttl = (TimeToLive)AnnotationUtils.findAnnotation((Method)timeoutMethod, TimeToLive.class);
                    try {
                        Number timeout = (Number)timeoutMethod.invoke(source, new Object[0]);
                        if (timeout != null) {
                            return TimeUnit.SECONDS.convert(timeout.longValue(), ttl.unit());
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Not allowed to access method '" + timeoutMethod.getName() + "': " + e.getMessage(), e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException("Cannot invoke method '" + timeoutMethod.getName() + " without arguments': " + e.getMessage(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("Cannot access method '" + timeoutMethod.getName() + "': " + e.getMessage(), e);
                    }
                }
            }
            return defaultTimeout;
        }

        private Long resolveDefaultTimeOut(Class<?> type) {
            Optional hash;
            if (this.defaultTimeouts.containsKey(type)) {
                return this.defaultTimeouts.get(type);
            }
            Long defaultTimeout = null;
            if (this.keyspaceConfig.hasSettingsFor(type)) {
                defaultTimeout = this.keyspaceConfig.getKeyspaceSettings(type).getTimeToLive();
            }
            if ((hash = ((RedisPersistentEntity)this.mappingContext.getPersistentEntity(type).get()).findAnnotation(RedisHash.class)).isPresent() && ((RedisHash)hash.get()).timeToLive() > 0L) {
                defaultTimeout = ((RedisHash)hash.get()).timeToLive();
            }
            this.defaultTimeouts.put(type, defaultTimeout);
            return defaultTimeout;
        }

        private PersistentProperty<?> resolveTtlProperty(Class<?> type) {
            KeyspaceConfiguration.KeyspaceSettings settings;
            if (this.timeoutProperties.containsKey(type)) {
                return this.timeoutProperties.get(type);
            }
            RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getPersistentEntity(type).get();
            Optional ttlProperty = entity.getPersistentProperty(TimeToLive.class);
            if (ttlProperty.isPresent()) {
                this.timeoutProperties.put(type, (PersistentProperty<?>)ttlProperty.get());
                return (PersistentProperty)ttlProperty.get();
            }
            if (this.keyspaceConfig.hasSettingsFor(type) && StringUtils.hasText((String)(settings = this.keyspaceConfig.getKeyspaceSettings(type)).getTimeToLivePropertyName()) && (ttlProperty = entity.getPersistentProperty(settings.getTimeToLivePropertyName())).isPresent()) {
                this.timeoutProperties.put(type, (PersistentProperty<?>)ttlProperty.get());
                return (PersistentProperty)ttlProperty.get();
            }
            this.timeoutProperties.put(type, null);
            return null;
        }

        private Method resolveTimeMethod(final Class<?> type) {
            if (this.timeoutMethods.containsKey(type)) {
                return this.timeoutMethods.get(type);
            }
            this.timeoutMethods.put(type, null);
            ReflectionUtils.doWithMethods(type, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    timeoutMethods.put(type, method);
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return ClassUtils.isAssignable(Number.class, method.getReturnType()) && AnnotationUtils.findAnnotation((Method)method, TimeToLive.class) != null;
                }
            });
            return this.timeoutMethods.get(type);
        }
    }

    static enum ClassNameKeySpaceResolver implements KeySpaceResolver
    {
        INSTANCE;


        public String resolveKeySpace(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return ClassUtils.getUserClass(type).getName();
        }
    }

    static class ConfigAwareKeySpaceResolver
    implements KeySpaceResolver {
        private final KeyspaceConfiguration keyspaceConfig;

        public ConfigAwareKeySpaceResolver(KeyspaceConfiguration keyspaceConfig) {
            this.keyspaceConfig = keyspaceConfig;
        }

        public String resolveKeySpace(Class<?> type) {
            String value;
            Assert.notNull(type, (String)"Type must not be null!");
            if (this.keyspaceConfig.hasSettingsFor(type) && StringUtils.hasText((String)(value = this.keyspaceConfig.getKeyspaceSettings(type).getKeyspace()))) {
                return value;
            }
            return ClassNameKeySpaceResolver.INSTANCE.resolveKeySpace(type);
        }
    }
}

