/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;

class LettuceSetCommands
implements RedisSetCommands {
    private final LettuceConnection connection;

    public LettuceSetCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long sAdd(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sadd((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sadd((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().sadd((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().scard((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().scard((Object)key)));
                return null;
            }
            return this.getConnection().scard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sdiff((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sdiff((Object[])keys)));
                return null;
            }
            return this.getConnection().sdiff((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sdiffstore((Object)destKey, (Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sdiffstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.getConnection().sdiffstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sinter((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sinter((Object[])keys)));
                return null;
            }
            return this.getConnection().sinter((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sinterstore((Object)destKey, (Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sinterstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.getConnection().sinterstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sismember((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sismember((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().sismember((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().smembers((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().smembers((Object)key)));
                return null;
            }
            return this.getConnection().smembers((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().smove((Object)srcKey, (Object)destKey, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().smove((Object)srcKey, (Object)destKey, (Object)value)));
                return null;
            }
            return this.getConnection().smove((Object)srcKey, (Object)destKey, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().spop((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().spop((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().spop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().srandmember((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().srandmember((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().srandmember((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sRandMember(byte[] key, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().srandmember((Object)key, count), LettuceConverters.bytesCollectionToBytesList()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().srandmember((Object)key, count), LettuceConverters.bytesCollectionToBytesList()));
                return null;
            }
            return LettuceConverters.toBytesList(this.getConnection().srandmember((Object)key, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sRem(byte[] key, byte[] ... values) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().srem((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().srem((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().srem((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sunion((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sunion((Object[])keys)));
                return null;
            }
            return this.getConnection().sunion((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future)this.getAsyncConnection().sunionstore((Object)destKey, (Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceTxResult(this.getConnection().sunionstore((Object)destKey, (Object[])keys)));
                return null;
            }
            return this.getConnection().sunionstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.sScan(key, 0L, options);
    }

    public Cursor<byte[]> sScan(byte[] key, long cursorId, ScanOptions options) {
        return new KeyBoundCursor<byte[]>(key, cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (LettuceSetCommands.this.isQueueing() || LettuceSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanCursor scanCursor = LettuceSetCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceSetCommands.this.connection.getScanArgs(options);
                ValueScanCursor valueScanCursor = LettuceSetCommands.this.getConnection().sscan((Object)key, scanCursor, scanArgs);
                String nextCursorId = valueScanCursor.getCursor();
                List values = (List)LettuceSetCommands.this.connection.failsafeReadScanValues(valueScanCursor.getValues(), null);
                return new ScanIteration<byte[]>(Long.valueOf(nextCursorId), values);
            }

            @Override
            protected void doClose() {
                LettuceSetCommands.this.connection.close();
            }
        }.open();
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceConnection.LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceConnection.LettuceTxResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }
}

