/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.SetArgs;
import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveStringCommands
implements ReactiveStringCommands {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final LettuceReactiveRedisConnection connection;

    public LettuceReactiveStringCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<List<ByteBuffer>, ByteBuffer>> mGet(Publisher<List<ByteBuffer>> keyCollections) {
        return this.connection.execute(cmd -> Flux.from((Publisher)keyCollections).flatMap(keys -> {
            Assert.notNull((Object)keys, (String)"Keys must not be null!");
            return cmd.mget((Object[])keys.stream().toArray(ByteBuffer[]::new)).map(value -> (ByteBuffer)value.getValueOrElse((Object)EMPTY_BYTE_BUFFER)).collectList().map(values -> new ReactiveRedisConnection.MultiValueResponse((List)keys, values));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> set(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            SetArgs args = null;
            if (command.getExpiration().isPresent() || command.getOption().isPresent()) {
                args = LettuceConverters.toSetArgs(command.getExpiration().isPresent() ? command.getExpiration().get() : null, command.getOption().isPresent() ? command.getOption().get() : null);
            }
            Mono mono = args != null ? cmd.set((Object)command.getKey(), (Object)command.getValue(), args) : cmd.set((Object)command.getKey(), (Object)command.getValue());
            return mono.map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.SetCommand>> getSet(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            if (command.getExpiration().isPresent() || command.getOption().isPresent()) {
                throw new IllegalArgumentException("Command must not define exipiration nor option for GETSET.");
            }
            return cmd.getset((Object)command.getKey(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (ByteBuffer)value)).defaultIfEmpty(new ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, EMPTY_BYTE_BUFFER));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> get(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            return cmd.get((Object)command.getKey()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (ByteBuffer)value)).defaultIfEmpty(new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, EMPTY_BYTE_BUFFER));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> setNX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            return cmd.setnx((Object)command.getKey(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> setEX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Assert.isTrue((boolean)command.getExpiration().isPresent(), (String)"Expiration time must not be null!");
            return cmd.setex((Object)command.getKey(), command.getExpiration().get().getExpirationTimeInSeconds(), (Object)command.getValue()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> pSetEX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Assert.isTrue((boolean)command.getExpiration().isPresent(), (String)"Expiration time must not be null!");
            return cmd.psetex((Object)command.getKey(), command.getExpiration().get().getExpirationTimeInMilliseconds(), (Object)command.getValue()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSet(Publisher<ReactiveStringCommands.MSetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notEmpty(command.getKeyValuePairs(), (String)"Pairs must not be null or empty!");
            return cmd.mset(command.getKeyValuePairs()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>((ReactiveStringCommands.MSetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSetNX(Publisher<ReactiveStringCommands.MSetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notEmpty(command.getKeyValuePairs(), (String)"Pairs must not be null or empty!");
            return cmd.msetnx(command.getKeyValuePairs()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>((ReactiveStringCommands.MSetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.AppendCommand, Long>> append(Publisher<ReactiveStringCommands.AppendCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            return cmd.append((Object)command.getKey(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.AppendCommand, Long>((ReactiveStringCommands.AppendCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.RangeCommand>> getRange(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull(command.getRange(), (String)"Range must not be null!");
            Range<Long> range = command.getRange();
            return cmd.getrange((Object)command.getKey(), ((Long)range.getLowerBound().getValue().orElse(null)).longValue(), ((Long)range.getUpperBound().getValue().orElse(null)).longValue()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.RangeCommand>((ReactiveRedisConnection.RangeCommand)command, (ByteBuffer)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.SetRangeCommand, Long>> setRange(Publisher<ReactiveStringCommands.SetRangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Assert.notNull((Object)command.getOffset(), (String)"Offset must not be null!");
            return cmd.setrange((Object)command.getKey(), command.getOffset().longValue(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.SetRangeCommand, Long>((ReactiveStringCommands.SetRangeCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.GetBitCommand>> getBit(Publisher<ReactiveStringCommands.GetBitCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getOffset(), (String)"Offset must not be null!");
            return cmd.getbit((Object)command.getKey(), command.getOffset().longValue()).map(Converters::toBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.GetBitCommand>((ReactiveStringCommands.GetBitCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetBitCommand>> setBit(Publisher<ReactiveStringCommands.SetBitCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            Assert.notNull((Object)command.getOffset(), (String)"Offset must not be null!");
            return cmd.setbit((Object)command.getKey(), command.getOffset().longValue(), command.getValue() ? 1 : 0).map(Converters::toBoolean).map(respValue -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetBitCommand>((ReactiveStringCommands.SetBitCommand)command, (Boolean)respValue));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitCountCommand, Long>> bitCount(Publisher<ReactiveStringCommands.BitCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Range<Long> range = command.getRange();
            return (range != null ? cmd.bitcount((Object)command.getKey(), ((Long)range.getLowerBound().getValue().orElse(null)).longValue(), ((Long)range.getUpperBound().getValue().orElse(null)).longValue()) : cmd.bitcount((Object)command.getKey())).map(responseValue -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitCountCommand, Long>((ReactiveStringCommands.BitCountCommand)command, (Long)responseValue));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitOpCommand, Long>> bitOp(Publisher<ReactiveStringCommands.BitOpCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getDestinationKey(), (String)"DestinationKey must not be null!");
            Assert.notEmpty(command.getKeys(), (String)"Keys must not be null or empty");
            Mono result = null;
            ByteBuffer destinationKey = command.getDestinationKey();
            Object[] sourceKeys = (ByteBuffer[])command.getKeys().stream().toArray(ByteBuffer[]::new);
            switch (command.getBitOp()) {
                case AND: {
                    result = cmd.bitopAnd((Object)destinationKey, sourceKeys);
                    break;
                }
                case OR: {
                    result = cmd.bitopOr((Object)destinationKey, sourceKeys);
                    break;
                }
                case XOR: {
                    result = cmd.bitopXor((Object)destinationKey, sourceKeys);
                    break;
                }
                case NOT: {
                    Assert.isTrue((sourceKeys.length == 1 ? 1 : 0) != 0, (String)"BITOP NOT does not allow more than 1 source key.");
                    result = cmd.bitopNot((Object)destinationKey, sourceKeys[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown BITOP '%s'.", new Object[]{command.getBitOp()}));
                }
            }
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitOpCommand, Long>((ReactiveStringCommands.BitOpCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> strLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> cmd.strlen((Object)command.getKey()).map(respValue -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)respValue))));
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

