/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.util.Map;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceStringCommands;

class LettuceClusterStringCommands
extends LettuceStringCommands {
    private final LettuceClusterConnection connection;

    public LettuceClusterStringCommands(LettuceClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys((byte[][])tuples.keySet().toArray((T[])new byte[tuples.keySet().size()][]))) {
            return super.mSetNX(tuples);
        }
        boolean result = true;
        for (Map.Entry<byte[], byte[]> entry : tuples.entrySet()) {
            if (this.setNX(entry.getKey(), entry.getValue()).booleanValue() || !result) continue;
            result = false;
        }
        return result;
    }
}

