/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceKeyCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class LettuceClusterKeyCommands
extends LettuceKeyCommands {
    private final LettuceClusterConnection connection;

    public LettuceClusterKeyCommands(LettuceClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public Cursor<byte[]> scan(long cursorId, ScanOptions options) {
        throw new InvalidDataAccessApiUsageException("Scan is not supported across multiple nodes within a cluster.");
    }

    @Override
    public byte[] randomKey() {
        Iterable nodes = this.connection.clusterGetNodes();
        HashSet<RedisClusterNode> inspectedNodes = new HashSet<RedisClusterNode>(nodes.size());
        do {
            RedisClusterNode node = (RedisClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            while (inspectedNodes.contains(node)) {
                node = (RedisClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            }
            inspectedNodes.add(node);
            byte[] key = this.randomKey(node);
            if (key == null || key.length <= 0) continue;
            return key;
        } while (nodes.size() != inspectedNodes.size());
        return null;
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        List keysPerNode = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(connection -> connection.keys((Object)pattern)).resultsAsList();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        for (List keySet : keysPerNode) {
            keys.addAll(keySet);
        }
        return keys;
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(oldName, newName)) {
            super.rename(oldName, newName);
            return;
        }
        byte[] value = this.dump(oldName);
        if (value != null && value.length > 0) {
            this.restore(newName, 0L, value);
            this.del(new byte[][]{oldName});
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(oldName, newName)) {
            return super.renameNX(oldName, newName);
        }
        byte[] value = this.dump(oldName);
        if (value != null && value.length > 0 && !this.exists(newName).booleanValue()) {
            this.restore(newName, 0L, value);
            this.del(new byte[][]{oldName});
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        throw new UnsupportedOperationException("MOVE not supported in CLUSTER mode!");
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.noNullElements((Object[])keys, (String)"Keys must not be null or contain null key!");
        return super.del(keys);
    }

    public byte[] randomKey(RedisClusterNode node) {
        return (byte[])this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> (byte[])client.randomkey(), node).getValue();
    }

    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        return LettuceConverters.toBytesSet((List)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> client.keys((Object)pattern), node).getValue());
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(key, storeKey)) {
            return super.sort(key, params, storeKey);
        }
        List<byte[]> sorted = this.sort(key, params);
        if (!CollectionUtils.isEmpty(sorted)) {
            byte[][] arr = new byte[sorted.size()][];
            switch (this.type(key)) {
                case SET: {
                    this.connection.setCommands().sAdd(storeKey, (byte[][])sorted.toArray((T[])arr));
                    return 1L;
                }
                case LIST: {
                    this.connection.listCommands().lPush(storeKey, (byte[][])sorted.toArray((T[])arr));
                    return 1L;
                }
            }
            throw new IllegalArgumentException("sort and store is only supported for SET and LIST");
        }
        return 0L;
    }
}

