/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;

class JedisKeyCommands
implements RedisKeyCommands {
    private final JedisConnection connection;

    public JedisKeyCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().exists(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().exists(key)));
                return null;
            }
            return this.connection.getJedis().exists(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().del(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().del(keys)));
                return null;
            }
            return this.connection.getJedis().del(keys);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().type(key), JedisConverters.stringToDataType()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().type(key), JedisConverters.stringToDataType()));
                return null;
            }
            return JedisConverters.toDataType(this.connection.getJedis().type(key));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().keys(pattern)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().keys(pattern)));
                return null;
            }
            return this.connection.getJedis().keys(pattern);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.scan(0L, options != null ? options : ScanOptions.NONE);
    }

    public Cursor<byte[]> scan(long cursorId, ScanOptions options) {
        return new ScanCursor<byte[]>(cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(long cursorId, ScanOptions options) {
                if (JedisKeyCommands.this.isQueueing() || JedisKeyCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisKeyCommands.this.connection.getJedis().scan(Long.toString(cursorId), params);
                return new ScanIteration<byte[]>(Long.valueOf(result.getStringCursor()), JedisConverters.stringListToByteList().convert(result.getResult()));
            }

            @Override
            protected void doClose() {
                JedisKeyCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().randomKeyBinary()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().randomKeyBinary()));
                return null;
            }
            return this.connection.getJedis().randomBinaryKey();
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().rename(oldName, newName)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().rename(oldName, newName)));
                return;
            }
            this.connection.getJedis().rename(oldName, newName);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().renamenx(oldName, newName), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().renamenx(oldName, newName), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().renamenx(oldName, newName));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (seconds > Integer.MAX_VALUE) {
            return this.pExpire(key, TimeUnit.SECONDS.toMillis(seconds));
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().expire(key, (int)seconds), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().expire(key, (int)seconds), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().expire(key, (int)seconds));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().expireAt(key, unixTime), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().expireAt(key, unixTime), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().expireAt(key, unixTime));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().pexpire(key, millis), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().pexpire(key, millis), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().pexpire(key, millis));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().pexpireAt(key, unixTimeInMillis), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().pexpireAt(key, unixTimeInMillis), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().pexpireAt(key, unixTimeInMillis));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().persist(key), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().persist(key), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().persist(key));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().move(key, dbIndex), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().move(key, dbIndex), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().move(key, dbIndex));
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().ttl(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().ttl(key)));
                return null;
            }
            return this.connection.getJedis().ttl(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().ttl(key), Converters.secondsToTimeUnit(timeUnit)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().ttl(key), Converters.secondsToTimeUnit(timeUnit)));
                return null;
            }
            return Converters.secondsToTimeUnit(this.connection.getJedis().ttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().pttl(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().pttl(key)));
                return null;
            }
            return this.connection.getJedis().pttl(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().pttl(key), Converters.millisecondsToTimeUnit(timeUnit)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().pttl(key), Converters.millisecondsToTimeUnit(timeUnit)));
                return null;
            }
            return Converters.millisecondsToTimeUnit(this.connection.getJedis().pttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        try {
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sort(key, sortParams)));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sort(key)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (sortParams != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sort(key, sortParams)));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sort(key)));
                }
                return null;
            }
            return sortParams != null ? this.connection.getJedis().sort(key, sortParams) : this.connection.getJedis().sort(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        try {
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sort(key, sortParams, storeKey)));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().sort(key, storeKey)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (sortParams != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sort(key, sortParams, storeKey)));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getTransaction().sort(key, storeKey)));
                }
                return null;
            }
            return sortParams != null ? this.connection.getJedis().sort(key, sortParams, storeKey) : this.connection.getJedis().sort(key, storeKey);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] dump(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getPipeline().dump(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getTransaction().dump(key)));
                return null;
            }
            return this.connection.getJedis().dump(key);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        if (ttlInMillis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("TtlInMillis must be less than Integer.MAX_VALUE for restore in Jedis.");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getPipeline().restore(key, (int)ttlInMillis, serializedValue)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getTransaction().restore(key, (int)ttlInMillis, serializedValue)));
                return;
            }
            this.connection.getJedis().restore(key, (int)ttlInMillis, serializedValue);
        }
        catch (Exception ex) {
            throw this.connection.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisConnection.JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisConnection.JedisResult result) {
        this.connection.transaction(result);
    }
}

