/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.util.ByteUtils;

class JedisClusterHyperLogLogCommands
implements RedisHyperLogLogCommands {
    private final JedisClusterConnection connection;

    public JedisClusterHyperLogLogCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        try {
            return this.connection.getCluster().pfadd(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().pfcount(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("All keys must map to same slot for pfcount in cluster mode.");
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destinationKey, sourceKeys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                this.connection.getCluster().pfmerge(destinationKey, sourceKeys);
                return;
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("All keys must map to same slot for pfmerge in cluster mode.");
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

