/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveSetCommands {
    default public Mono<Long> sAdd(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.sAdd(key, Collections.singletonList(value));
    }

    default public Mono<Long> sAdd(ByteBuffer key, Collection<ByteBuffer> values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        return this.sAdd((Publisher<SAddCommand>)Mono.just((Object)SAddCommand.values(values).to(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<SAddCommand, Long>> sAdd(Publisher<SAddCommand> var1);

    default public Mono<Long> sRem(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.sRem(key, Collections.singletonList(value));
    }

    default public Mono<Long> sRem(ByteBuffer key, Collection<ByteBuffer> values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        return this.sRem((Publisher<SRemCommand>)Mono.just((Object)SRemCommand.values(values).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<SRemCommand, Long>> sRem(Publisher<SRemCommand> var1);

    default public Mono<ByteBuffer> sPop(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.sPop((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> sPop(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Boolean> sMove(ByteBuffer sourceKey, ByteBuffer destinationKey, ByteBuffer value) {
        Assert.notNull((Object)sourceKey, (String)"SourceKey must not be null!");
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.sMove((Publisher<SMoveCommand>)Mono.just((Object)SMoveCommand.value(value).from(sourceKey).to(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<SMoveCommand>> sMove(Publisher<SMoveCommand> var1);

    default public Mono<Long> sCard(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.sCard((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> sCard(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Boolean> sIsMember(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.sIsMember((Publisher<SIsMemberCommand>)Mono.just((Object)SIsMemberCommand.value(value).of(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<SIsMemberCommand>> sIsMember(Publisher<SIsMemberCommand> var1);

    default public Flux<ByteBuffer> sInter(Collection<ByteBuffer> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.sInter((Publisher<SInterCommand>)Mono.just((Object)SInterCommand.keys(keys))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<SInterCommand, Flux<ByteBuffer>>> sInter(Publisher<SInterCommand> var1);

    default public Mono<Long> sInterStore(ByteBuffer destinationKey, Collection<ByteBuffer> keys) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.sInterStore((Publisher<SInterStoreCommand>)Mono.just((Object)SInterStoreCommand.keys(keys).storeAt(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<SInterStoreCommand, Long>> sInterStore(Publisher<SInterStoreCommand> var1);

    default public Flux<ByteBuffer> sUnion(Collection<ByteBuffer> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.sUnion((Publisher<SUnionCommand>)Mono.just((Object)SUnionCommand.keys(keys))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<SUnionCommand, Flux<ByteBuffer>>> sUnion(Publisher<SUnionCommand> var1);

    default public Mono<Long> sUnionStore(ByteBuffer destinationKey, Collection<ByteBuffer> keys) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.sUnionStore((Publisher<SUnionStoreCommand>)Mono.just((Object)SUnionStoreCommand.keys(keys).storeAt(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<SUnionStoreCommand, Long>> sUnionStore(Publisher<SUnionStoreCommand> var1);

    default public Flux<ByteBuffer> sDiff(Collection<ByteBuffer> keys) {
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.sDiff((Publisher<SDiffCommand>)Mono.just((Object)SDiffCommand.keys(keys))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<SDiffCommand, Flux<ByteBuffer>>> sDiff(Publisher<SDiffCommand> var1);

    default public Mono<Long> sDiffStore(ByteBuffer destinationKey, Collection<ByteBuffer> keys) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(keys, (String)"Keys must not be null!");
        return this.sDiffStore((Publisher<SDiffStoreCommand>)Mono.just((Object)SDiffStoreCommand.keys(keys).storeAt(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<SDiffStoreCommand, Long>> sDiffStore(Publisher<SDiffStoreCommand> var1);

    default public Flux<ByteBuffer> sMembers(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.sMembers((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> sMembers(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<ByteBuffer> sRandMember(ByteBuffer key) {
        return this.sRandMember(key, 1L).singleOrEmpty();
    }

    default public Flux<ByteBuffer> sRandMember(ByteBuffer key, Long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)count, (String)"Count must not be null!");
        return this.sRandMember((Publisher<SRandMembersCommand>)Mono.just((Object)SRandMembersCommand.valueCount(count).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<SRandMembersCommand, Flux<ByteBuffer>>> sRandMember(Publisher<SRandMembersCommand> var1);

    public static class SRandMembersCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Long count;

        private SRandMembersCommand(ByteBuffer key, Long count) {
            super(key);
            this.count = count;
        }

        public static SRandMembersCommand valueCount(long nrValuesToRetrieve) {
            return new SRandMembersCommand(null, nrValuesToRetrieve);
        }

        public static SRandMembersCommand singleValue() {
            return new SRandMembersCommand(null, null);
        }

        public SRandMembersCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new SRandMembersCommand(key, this.count);
        }

        public Optional<Long> getCount() {
            return Optional.ofNullable(this.count);
        }
    }

    public static class SDiffStoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> keys;

        private SDiffStoreCommand(ByteBuffer key, List<ByteBuffer> keys) {
            super(key);
            this.keys = keys;
        }

        public static SDiffStoreCommand keys(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new SDiffStoreCommand(null, new ArrayList<ByteBuffer>(keys));
        }

        public SDiffStoreCommand storeAt(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new SDiffStoreCommand(key, this.keys);
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }
    }

    public static class SDiffCommand
    implements ReactiveRedisConnection.Command {
        private final List<ByteBuffer> keys;

        private SDiffCommand(List<ByteBuffer> keys) {
            this.keys = keys;
        }

        public static SDiffCommand keys(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new SDiffCommand(new ArrayList<ByteBuffer>(keys));
        }

        @Override
        public ByteBuffer getKey() {
            return null;
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }
    }

    public static class SUnionStoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> keys;

        private SUnionStoreCommand(ByteBuffer key, List<ByteBuffer> keys) {
            super(key);
            this.keys = keys;
        }

        public static SUnionStoreCommand keys(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new SUnionStoreCommand(null, new ArrayList<ByteBuffer>(keys));
        }

        public SUnionStoreCommand storeAt(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new SUnionStoreCommand(key, this.keys);
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }
    }

    public static class SUnionCommand
    implements ReactiveRedisConnection.Command {
        private final List<ByteBuffer> keys;

        private SUnionCommand(List<ByteBuffer> keys) {
            this.keys = keys;
        }

        public static SUnionCommand keys(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new SUnionCommand(new ArrayList<ByteBuffer>(keys));
        }

        @Override
        public ByteBuffer getKey() {
            return null;
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }
    }

    public static class SInterStoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> keys;

        private SInterStoreCommand(ByteBuffer key, List<ByteBuffer> keys) {
            super(key);
            this.keys = keys;
        }

        public static SInterStoreCommand keys(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new SInterStoreCommand(null, new ArrayList<ByteBuffer>(keys));
        }

        public SInterStoreCommand storeAt(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new SInterStoreCommand(key, this.keys);
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }
    }

    public static class SInterCommand
    implements ReactiveRedisConnection.Command {
        private final List<ByteBuffer> keys;

        private SInterCommand(List<ByteBuffer> keys) {
            this.keys = keys;
        }

        public static SInterCommand keys(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new SInterCommand(new ArrayList<ByteBuffer>(keys));
        }

        @Override
        public ByteBuffer getKey() {
            return null;
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }
    }

    public static class SIsMemberCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer value;

        private SIsMemberCommand(ByteBuffer key, ByteBuffer value) {
            super(key);
            this.value = value;
        }

        public static SIsMemberCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new SIsMemberCommand(null, value);
        }

        public SIsMemberCommand of(ByteBuffer set) {
            Assert.notNull((Object)set, (String)"Set key must not be null!");
            return new SIsMemberCommand(set, this.value);
        }

        public ByteBuffer getValue() {
            return this.value;
        }
    }

    public static class SMoveCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer destination;
        private final ByteBuffer value;

        private SMoveCommand(ByteBuffer key, ByteBuffer destination, ByteBuffer value) {
            super(key);
            this.destination = destination;
            this.value = value;
        }

        public static SMoveCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new SMoveCommand(null, null, value);
        }

        public SMoveCommand from(ByteBuffer source) {
            Assert.notNull((Object)source, (String)"Source key must not be null!");
            return new SMoveCommand(source, this.destination, this.value);
        }

        public SMoveCommand to(ByteBuffer destination) {
            Assert.notNull((Object)destination, (String)"Destination key must not be null!");
            return new SMoveCommand(this.getKey(), destination, this.value);
        }

        public ByteBuffer getDestination() {
            return this.destination;
        }

        public ByteBuffer getValue() {
            return this.value;
        }
    }

    public static class SRemCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> values;

        private SRemCommand(ByteBuffer key, List<ByteBuffer> values) {
            super(key);
            this.values = values;
        }

        public static SRemCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return SRemCommand.values(Collections.singletonList(value));
        }

        public static SRemCommand values(Collection<ByteBuffer> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            return new SRemCommand(null, new ArrayList<ByteBuffer>(values));
        }

        public SRemCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new SRemCommand(key, this.values);
        }

        public List<ByteBuffer> getValues() {
            return this.values;
        }
    }

    public static class SAddCommand
    extends ReactiveRedisConnection.KeyCommand {
        private List<ByteBuffer> values;

        private SAddCommand(ByteBuffer key, List<ByteBuffer> values) {
            super(key);
            this.values = values;
        }

        public static SAddCommand value(ByteBuffer value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return SAddCommand.values(Collections.singletonList(value));
        }

        public static SAddCommand values(Collection<ByteBuffer> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            return new SAddCommand(null, new ArrayList<ByteBuffer>(values));
        }

        public SAddCommand to(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new SAddCommand(key, this.values);
        }

        public List<ByteBuffer> getValues() {
            return this.values;
        }
    }
}

