/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.rjc;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.idevlab.rjc.Client;
import org.idevlab.rjc.ElementScore;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.SortingParams;
import org.idevlab.rjc.ZParams;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.util.DecodeUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RjcUtils {
    private static final String ONE = "1";
    private static final String ZERO = "0";

    public static DataAccessException convertRjcAccessException(RuntimeException ex) {
        if (ex instanceof RedisException) {
            return RjcUtils.convertRjcAccessException((RedisException)ex);
        }
        return new RedisSystemException("Unknown exception", ex);
    }

    public static DataAccessException convertRjcAccessException(RedisException ex) {
        return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
    }

    static DataType convertDataType(String type) {
        if ("string".equals(type)) {
            return DataType.STRING;
        }
        if ("list".equals(type)) {
            return DataType.LIST;
        }
        if ("set".equals(type)) {
            return DataType.SET;
        }
        if ("zset".equals(type)) {
            return DataType.ZSET;
        }
        if ("hash".equals(type)) {
            return DataType.HASH;
        }
        if ("none".equals(type)) {
            return DataType.NONE;
        }
        return null;
    }

    static String decode(byte[] bytes) {
        return DecodeUtils.decode(bytes);
    }

    static byte[] encode(String string) {
        return DecodeUtils.encode(string);
    }

    static String[] decodeMultiple(byte[] ... bytes) {
        return DecodeUtils.decodeMultiple(bytes);
    }

    static String[] flatten(Map<byte[], byte[]> tuple) {
        String[] result = new String[tuple.size() * 2];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
            result[index++] = RjcUtils.decode(entry.getKey());
            result[index++] = RjcUtils.decode(entry.getValue());
        }
        return result;
    }

    static Set<byte[]> convertToSet(Collection<String> keys) {
        if (keys == null) {
            return null;
        }
        return DecodeUtils.convertToSet(keys);
    }

    static List<byte[]> convertToList(Collection<String> keys) {
        if (keys == null) {
            return null;
        }
        return DecodeUtils.convertToList(keys);
    }

    static SortingParams convertSortParams(SortParameters params) {
        SortingParams rjcSort = null;
        if (params != null) {
            Boolean isAlpha;
            SortParameters.Order order;
            SortParameters.Range limit;
            byte[][] getPattern;
            rjcSort = new SortingParams();
            byte[] byPattern = params.getByPattern();
            if (byPattern != null) {
                rjcSort.by(DecodeUtils.decode(byPattern));
            }
            if ((getPattern = params.getGetPattern()) != null && getPattern.length > 0) {
                for (byte[] bs : getPattern) {
                    rjcSort.get(new String[]{DecodeUtils.decode(bs)});
                }
            }
            if ((limit = params.getLimit()) != null) {
                rjcSort.limit((int)limit.getStart(), (int)limit.getCount());
            }
            if ((order = params.getOrder()) != null && order.equals((Object)SortParameters.Order.DESC)) {
                rjcSort.desc();
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                rjcSort.alpha();
            }
        }
        return rjcSort;
    }

    static Properties info(String string) {
        Properties info = new Properties();
        StringReader stringReader = new StringReader(string);
        try {
            info.load(stringReader);
        }
        catch (Exception ex) {
            throw new RedisSystemException("Cannot read Redis info", ex);
        }
        finally {
            stringReader.close();
        }
        return info;
    }

    static String asBit(boolean value) {
        return value ? ONE : ZERO;
    }

    static Client.LIST_POSITION convertPosition(RedisListCommands.Position where) {
        switch (where) {
            case BEFORE: {
                return Client.LIST_POSITION.BEFORE;
            }
            case AFTER: {
                return Client.LIST_POSITION.AFTER;
            }
        }
        return null;
    }

    static ZParams toZParams(RedisZSetCommands.Aggregate aggregate, int[] weights) {
        return new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
    }

    static Set<RedisZSetCommands.Tuple> convertElementScore(List<ElementScore> tuples) {
        LinkedHashSet<RedisZSetCommands.Tuple> value = new LinkedHashSet<RedisZSetCommands.Tuple>(tuples.size());
        for (ElementScore tuple : tuples) {
            value.add(new DefaultTuple(RjcUtils.encode(tuple.getElement()), Double.valueOf(tuple.getScore())));
        }
        return value;
    }

    static Map<byte[], byte[]> encodeMap(Map<String, String> map) {
        LinkedHashMap<byte[], byte[]> result = new LinkedHashMap<byte[], byte[]>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(RjcUtils.encode(entry.getKey()), RjcUtils.encode(entry.getValue()));
        }
        return result;
    }

    static Map<String, String> decodeMap(Map<byte[], byte[]> map) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(map.size());
        for (Map.Entry<byte[], byte[]> entry : map.entrySet()) {
            result.put(RjcUtils.decode(entry.getKey()), RjcUtils.decode(entry.getValue()));
        }
        return result;
    }

    static Double convert(String zscore) {
        return zscore == null ? null : Double.valueOf(zscore);
    }

    static String[] addArray(String[] one, String[] two) {
        if (ObjectUtils.isEmpty((Object[])one)) {
            return two;
        }
        if (ObjectUtils.isEmpty((Object[])two)) {
            return one;
        }
        String[] result = Arrays.copyOf(one, one.length + two.length);
        System.arraycopy(two, 0, result, one.length, two.length);
        return result;
    }
}

