/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.DefaultStringTuple;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStringRedisConnection
implements StringRedisConnection {
    private final RedisConnection delegate;
    private final RedisSerializer<String> serializer;

    public DefaultStringRedisConnection(RedisConnection connection) {
        Assert.notNull((Object)connection, (String)"connection is required");
        this.delegate = connection;
        this.serializer = new StringRedisSerializer();
    }

    public DefaultStringRedisConnection(RedisConnection connection, RedisSerializer<String> serializer) {
        Assert.notNull((Object)connection, (String)"connection is required");
        Assert.notNull((Object)connection, (String)"serializer is required");
        this.delegate = connection;
        this.serializer = serializer;
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        return this.delegate.append(key, value);
    }

    @Override
    public void bgSave() {
        this.delegate.bgSave();
    }

    @Override
    public void bgWriteAof() {
        this.delegate.bgWriteAof();
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        return this.delegate.bLPop(timeout, keys);
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        return this.delegate.bRPop(timeout, keys);
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        return this.delegate.bRPopLPush(timeout, srcKey, dstKey);
    }

    @Override
    public void close() throws RedisSystemException {
        this.delegate.close();
    }

    @Override
    public Long dbSize() {
        return this.delegate.dbSize();
    }

    @Override
    public Long decr(byte[] key) {
        return this.delegate.decr(key);
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        return this.delegate.decrBy(key, value);
    }

    @Override
    public Long del(byte[] ... keys) {
        return this.delegate.del(keys);
    }

    @Override
    public void discard() {
        this.delegate.discard();
    }

    @Override
    public byte[] echo(byte[] message) {
        return this.delegate.echo(message);
    }

    @Override
    public List<Object> exec() {
        return this.delegate.exec();
    }

    @Override
    public Boolean exists(byte[] key) {
        return this.delegate.exists(key);
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        return this.delegate.expire(key, seconds);
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        return this.delegate.expireAt(key, unixTime);
    }

    @Override
    public void flushAll() {
        this.delegate.flushAll();
    }

    @Override
    public void flushDb() {
        this.delegate.flushDb();
    }

    @Override
    public byte[] get(byte[] key) {
        return this.delegate.get(key);
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        return this.delegate.getBit(key, offset);
    }

    @Override
    public List<String> getConfig(String pattern) {
        return this.delegate.getConfig(pattern);
    }

    @Override
    public Object getNativeConnection() {
        return this.delegate.getNativeConnection();
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        return this.delegate.getRange(key, start, end);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        return this.delegate.getSet(key, value);
    }

    @Override
    public Subscription getSubscription() {
        return this.delegate.getSubscription();
    }

    @Override
    public Boolean hDel(byte[] key, byte[] field) {
        return this.delegate.hDel(key, field);
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        return this.delegate.hExists(key, field);
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        return this.delegate.hGet(key, field);
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        return this.delegate.hGetAll(key);
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        return this.delegate.hIncrBy(key, field, delta);
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        return this.delegate.hKeys(key);
    }

    @Override
    public Long hLen(byte[] key) {
        return this.delegate.hLen(key);
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        return this.delegate.hMGet(key, fields);
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        this.delegate.hMSet(key, hashes);
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        return this.delegate.hSet(key, field, value);
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        return this.delegate.hSetNX(key, field, value);
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        return this.delegate.hVals(key);
    }

    @Override
    public Long incr(byte[] key) {
        return this.delegate.incr(key);
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        return this.delegate.incrBy(key, value);
    }

    @Override
    public Properties info() {
        return this.delegate.info();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isQueueing() {
        return this.delegate.isQueueing();
    }

    @Override
    public boolean isSubscribed() {
        return this.delegate.isSubscribed();
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        return this.delegate.keys(pattern);
    }

    @Override
    public Long lastSave() {
        return this.delegate.lastSave();
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        return this.delegate.lIndex(key, index);
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        return this.delegate.lInsert(key, where, pivot, value);
    }

    @Override
    public Long lLen(byte[] key) {
        return this.delegate.lLen(key);
    }

    @Override
    public byte[] lPop(byte[] key) {
        return this.delegate.lPop(key);
    }

    @Override
    public Long lPush(byte[] key, byte[] value) {
        return this.delegate.lPush(key, value);
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        return this.delegate.lPushX(key, value);
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        return this.delegate.lRange(key, start, end);
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        return this.delegate.lRem(key, count, value);
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        this.delegate.lSet(key, index, value);
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        this.delegate.lTrim(key, start, end);
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        return this.delegate.mGet(keys);
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuple) {
        this.delegate.mSet(tuple);
    }

    @Override
    public void mSetNX(Map<byte[], byte[]> tuple) {
        this.delegate.mSetNX(tuple);
    }

    @Override
    public void multi() {
        this.delegate.multi();
    }

    @Override
    public Boolean persist(byte[] key) {
        return this.delegate.persist(key);
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        return this.delegate.move(key, dbIndex);
    }

    @Override
    public String ping() {
        return this.delegate.ping();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.delegate.pSubscribe(listener, patterns);
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        return this.delegate.publish(channel, message);
    }

    @Override
    public byte[] randomKey() {
        return this.delegate.randomKey();
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        this.delegate.rename(oldName, newName);
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        return this.delegate.renameNX(oldName, newName);
    }

    @Override
    public void resetConfigStats() {
        this.delegate.resetConfigStats();
    }

    @Override
    public byte[] rPop(byte[] key) {
        return this.delegate.rPop(key);
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        return this.delegate.rPopLPush(srcKey, dstKey);
    }

    @Override
    public Long rPush(byte[] key, byte[] value) {
        return this.delegate.rPush(key, value);
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        return this.delegate.rPushX(key, value);
    }

    @Override
    public Boolean sAdd(byte[] key, byte[] value) {
        return this.delegate.sAdd(key, value);
    }

    @Override
    public void save() {
        this.delegate.save();
    }

    @Override
    public Long sCard(byte[] key) {
        return this.delegate.sCard(key);
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        return this.delegate.sDiff(keys);
    }

    @Override
    public void sDiffStore(byte[] destKey, byte[] ... keys) {
        this.delegate.sDiffStore(destKey, keys);
    }

    @Override
    public void select(int dbIndex) {
        this.delegate.select(dbIndex);
    }

    @Override
    public void set(byte[] key, byte[] value) {
        this.delegate.set(key, value);
    }

    @Override
    public void setBit(byte[] key, long offset, boolean value) {
        this.delegate.setBit(key, offset, value);
    }

    @Override
    public void setConfig(String param, String value) {
        this.delegate.setConfig(param, value);
    }

    @Override
    public void setEx(byte[] key, long seconds, byte[] value) {
        this.delegate.setEx(key, seconds, value);
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        return this.delegate.setNX(key, value);
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        this.delegate.setRange(key, value, start);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        return this.delegate.sInter(keys);
    }

    @Override
    public void sInterStore(byte[] destKey, byte[] ... keys) {
        this.delegate.sInterStore(destKey, keys);
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        return this.delegate.sIsMember(key, value);
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        return this.delegate.sMembers(key);
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        return this.delegate.sMove(srcKey, destKey, value);
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        return this.delegate.sort(key, params, storeKey);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        return this.delegate.sort(key, params);
    }

    @Override
    public byte[] sPop(byte[] key) {
        return this.delegate.sPop(key);
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        return this.delegate.sRandMember(key);
    }

    @Override
    public Boolean sRem(byte[] key, byte[] value) {
        return this.delegate.sRem(key, value);
    }

    @Override
    public Long strLen(byte[] key) {
        return this.delegate.strLen(key);
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.delegate.subscribe(listener, channels);
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        return this.delegate.sUnion(keys);
    }

    @Override
    public void sUnionStore(byte[] destKey, byte[] ... keys) {
        this.delegate.sUnionStore(destKey, keys);
    }

    @Override
    public Long ttl(byte[] key) {
        return this.delegate.ttl(key);
    }

    @Override
    public DataType type(byte[] key) {
        return this.delegate.type(key);
    }

    @Override
    public void unwatch() {
        this.delegate.unwatch();
    }

    @Override
    public void watch(byte[] ... keys) {
        this.delegate.watch(keys);
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        return this.delegate.zAdd(key, score, value);
    }

    @Override
    public Long zCard(byte[] key) {
        return this.delegate.zCard(key);
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        return this.delegate.zCount(key, min, max);
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        return this.delegate.zIncrBy(key, increment, value);
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.delegate.zInterStore(destKey, aggregate, weights, sets);
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        return this.delegate.zInterStore(destKey, sets);
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        return this.delegate.zRange(key, start, end);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.delegate.zRangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return this.delegate.zRangeByScore(key, min, max);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.delegate.zRangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.delegate.zRangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        return this.delegate.zRangeWithScores(key, start, end);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.delegate.zRevRangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.delegate.zRevRangeByScore(key, min, max);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.delegate.zRevRangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.delegate.zRevRangeByScoreWithScores(key, min, max);
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        return this.delegate.zRank(key, value);
    }

    @Override
    public Boolean zRem(byte[] key, byte[] value) {
        return this.delegate.zRem(key, value);
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        return this.delegate.zRemRange(key, start, end);
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.delegate.zRemRangeByScore(key, min, max);
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        return this.delegate.zRevRange(key, start, end);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        return this.delegate.zRevRangeWithScores(key, start, end);
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        return this.delegate.zRevRank(key, value);
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        return this.delegate.zScore(key, value);
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.delegate.zUnionStore(destKey, aggregate, weights, sets);
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        return this.delegate.zUnionStore(destKey, sets);
    }

    private byte[] serialize(String data) {
        return this.serializer.serialize(data);
    }

    private byte[][] serializeMulti(String ... keys) {
        byte[][] ret = new byte[keys.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.serializer.serialize(keys[i]);
        }
        return ret;
    }

    private Map<byte[], byte[]> serialize(Map<String, String> hashes) {
        LinkedHashMap<byte[], byte[]> ret = new LinkedHashMap<byte[], byte[]>(hashes.size());
        for (Map.Entry<String, String> entry : hashes.entrySet()) {
            ret.put(this.serializer.serialize(entry.getKey()), this.serializer.serialize(entry.getValue()));
        }
        return ret;
    }

    private List<String> deserialize(List<byte[]> data) {
        return SerializationUtils.deserialize(data, this.serializer);
    }

    private Set<String> deserialize(Set<byte[]> data) {
        return SerializationUtils.deserialize(data, this.serializer);
    }

    private String deserialize(byte[] data) {
        return this.serializer.deserialize(data);
    }

    private Set<StringRedisConnection.StringTuple> deserializeTuple(Set<RedisZSetCommands.Tuple> data) {
        if (data == null) {
            return null;
        }
        LinkedHashSet<StringRedisConnection.StringTuple> result = new LinkedHashSet<StringRedisConnection.StringTuple>(data.size());
        for (RedisZSetCommands.Tuple raw : data) {
            result.add(new DefaultStringTuple(raw, this.serializer.deserialize(raw.getValue())));
        }
        return result;
    }

    @Override
    public Long append(String key, String value) {
        return this.delegate.append(this.serialize(key), this.serialize(value));
    }

    @Override
    public List<String> bLPop(int timeout, String ... keys) {
        return this.deserialize(this.delegate.bLPop(timeout, this.serializeMulti(keys)));
    }

    @Override
    public List<String> bRPop(int timeout, String ... keys) {
        return this.deserialize(this.delegate.bRPop(timeout, this.serializeMulti(keys)));
    }

    @Override
    public String bRPopLPush(int timeout, String srcKey, String dstKey) {
        return this.deserialize(this.delegate.bRPopLPush(timeout, this.serialize(srcKey), this.serialize(dstKey)));
    }

    @Override
    public Long decr(String key) {
        return this.delegate.decr(this.serialize(key));
    }

    @Override
    public Long decrBy(String key, long value) {
        return this.delegate.decrBy(this.serialize(key), value);
    }

    @Override
    public Long del(String ... keys) {
        return this.delegate.del(this.serializeMulti(keys));
    }

    @Override
    public String echo(String message) {
        return this.deserialize(this.delegate.echo(this.serialize(message)));
    }

    @Override
    public Boolean exists(String key) {
        return this.delegate.exists(this.serialize(key));
    }

    @Override
    public Boolean expire(String key, long seconds) {
        return this.delegate.expire(this.serialize(key), seconds);
    }

    @Override
    public Boolean expireAt(String key, long unixTime) {
        return this.delegate.expireAt(this.serialize(key), unixTime);
    }

    @Override
    public String get(String key) {
        return this.deserialize(this.delegate.get(this.serialize(key)));
    }

    @Override
    public Boolean getBit(String key, long offset) {
        return this.delegate.getBit(this.serialize(key), offset);
    }

    @Override
    public String getRange(String key, long start, long end) {
        return this.deserialize(this.delegate.getRange(this.serialize(key), start, end));
    }

    @Override
    public String getSet(String key, String value) {
        return this.deserialize(this.delegate.getSet(this.serialize(key), this.serialize(value)));
    }

    @Override
    public Boolean hDel(String key, String field) {
        return this.delegate.hDel(this.serialize(key), this.serialize(field));
    }

    @Override
    public Boolean hExists(String key, String field) {
        return this.delegate.hExists(this.serialize(key), this.serialize(field));
    }

    @Override
    public String hGet(String key, String field) {
        return this.deserialize(this.delegate.hGet(this.serialize(key), this.serialize(field)));
    }

    @Override
    public Map<String, String> hGetAll(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long hIncrBy(String key, String field, long delta) {
        return this.delegate.hIncrBy(this.serialize(key), this.serialize(field), delta);
    }

    @Override
    public Set<String> hKeys(String key) {
        return this.deserialize(this.delegate.hKeys(this.serialize(key)));
    }

    @Override
    public Long hLen(String key) {
        return this.delegate.hLen(this.serialize(key));
    }

    @Override
    public List<String> hMGet(String key, String ... fields) {
        return this.deserialize(this.delegate.hMGet(this.serialize(key), this.serializeMulti(fields)));
    }

    @Override
    public void hMSet(String key, Map<String, String> hashes) {
        this.delegate.hMSet(this.serialize(key), this.serialize(hashes));
    }

    @Override
    public Boolean hSet(String key, String field, String value) {
        return this.delegate.hSet(this.serialize(key), this.serialize(field), this.serialize(value));
    }

    @Override
    public Boolean hSetNX(String key, String field, String value) {
        return this.delegate.hSetNX(this.serialize(key), this.serialize(field), this.serialize(value));
    }

    @Override
    public List<String> hVals(String key) {
        return this.deserialize(this.delegate.hVals(this.serialize(key)));
    }

    @Override
    public Long incr(String key) {
        return this.delegate.incr(this.serialize(key));
    }

    @Override
    public Long incrBy(String key, long value) {
        return this.delegate.incrBy(this.serialize(key), value);
    }

    @Override
    public Collection<String> keys(String pattern) {
        return this.deserialize(this.delegate.keys(this.serialize(pattern)));
    }

    @Override
    public String lIndex(String key, long index) {
        return this.deserialize(this.delegate.lIndex(this.serialize(key), index));
    }

    @Override
    public Long lInsert(String key, RedisListCommands.Position where, String pivot, String value) {
        return this.delegate.lInsert(this.serialize(key), where, this.serialize(pivot), this.serialize(value));
    }

    @Override
    public Long lLen(String key) {
        return this.delegate.lLen(this.serialize(key));
    }

    @Override
    public String lPop(String key) {
        return this.deserialize(this.delegate.lPop(this.serialize(key)));
    }

    @Override
    public Long lPush(String key, String value) {
        return this.delegate.lPush(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long lPushX(String key, String value) {
        return this.delegate.lPushX(this.serialize(key), this.serialize(value));
    }

    @Override
    public List<String> lRange(String key, long start, long end) {
        return this.deserialize(this.delegate.lRange(this.serialize(key), start, end));
    }

    @Override
    public Long lRem(String key, long count, String value) {
        return this.delegate.lRem(this.serialize(key), count, this.serialize(value));
    }

    @Override
    public void lSet(String key, long index, String value) {
        this.delegate.lSet(this.serialize(key), index, this.serialize(value));
    }

    @Override
    public void lTrim(String key, long start, long end) {
        this.delegate.lTrim(this.serialize(key), start, end);
    }

    @Override
    public List<String> mGet(String ... keys) {
        return this.deserialize(this.delegate.mGet(this.serializeMulti(keys)));
    }

    @Override
    public void mSetNXString(Map<String, String> tuple) {
        this.delegate.mSetNX(this.serialize(tuple));
    }

    @Override
    public void mSetString(Map<String, String> tuple) {
        this.delegate.mSet(this.serialize(tuple));
    }

    @Override
    public Boolean persist(String key) {
        return this.delegate.persist(this.serialize(key));
    }

    @Override
    public Boolean move(String key, int dbIndex) {
        return this.delegate.move(this.serialize(key), dbIndex);
    }

    @Override
    public void pSubscribe(MessageListener listener, String ... patterns) {
        this.delegate.pSubscribe(listener, this.serializeMulti(patterns));
    }

    @Override
    public Long publish(String channel, String message) {
        return this.delegate.publish(this.serialize(channel), this.serialize(message));
    }

    @Override
    public void rename(String oldName, String newName) {
        this.delegate.rename(this.serialize(oldName), this.serialize(newName));
    }

    @Override
    public Boolean renameNX(String oldName, String newName) {
        return this.delegate.renameNX(this.serialize(oldName), this.serialize(newName));
    }

    @Override
    public String rPop(String key) {
        return this.deserialize(this.delegate.rPop(this.serialize(key)));
    }

    @Override
    public String rPopLPush(String srcKey, String dstKey) {
        return this.deserialize(this.delegate.rPopLPush(this.serialize(srcKey), this.serialize(dstKey)));
    }

    @Override
    public Long rPush(String key, String value) {
        return this.delegate.rPush(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long rPushX(String key, String value) {
        return this.delegate.rPushX(this.serialize(key), this.serialize(value));
    }

    @Override
    public Boolean sAdd(String key, String value) {
        return this.delegate.sAdd(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long sCard(String key) {
        return this.delegate.sCard(this.serialize(key));
    }

    @Override
    public Set<String> sDiff(String ... keys) {
        return this.deserialize(this.delegate.sDiff(this.serializeMulti(keys)));
    }

    @Override
    public void sDiffStore(String destKey, String ... keys) {
        this.delegate.sDiffStore(this.serialize(destKey), this.serializeMulti(keys));
    }

    @Override
    public void set(String key, String value) {
        this.delegate.set(this.serialize(key), this.serialize(value));
    }

    @Override
    public void setBit(String key, long offset, boolean value) {
        this.delegate.setBit(this.serialize(key), offset, value);
    }

    @Override
    public void setEx(String key, long seconds, String value) {
        this.delegate.setEx(this.serialize(key), seconds, this.serialize(value));
    }

    @Override
    public Boolean setNX(String key, String value) {
        return this.delegate.setNX(this.serialize(key), this.serialize(value));
    }

    @Override
    public void setRange(String key, String value, long start) {
        this.delegate.setRange(this.serialize(key), this.serialize(value), start);
    }

    @Override
    public Set<String> sInter(String ... keys) {
        return this.deserialize(this.delegate.sInter(this.serializeMulti(keys)));
    }

    @Override
    public void sInterStore(String destKey, String ... keys) {
        this.delegate.sInterStore(this.serialize(destKey), this.serializeMulti(keys));
    }

    @Override
    public Boolean sIsMember(String key, String value) {
        return this.delegate.sIsMember(this.serialize(key), this.serialize(value));
    }

    @Override
    public Set<String> sMembers(String key) {
        return this.deserialize(this.delegate.sMembers(this.serialize(key)));
    }

    @Override
    public Boolean sMove(String srcKey, String destKey, String value) {
        return this.delegate.sMove(this.serialize(srcKey), this.serialize(destKey), this.serialize(value));
    }

    @Override
    public Long sort(String key, SortParameters params, String storeKey) {
        return this.delegate.sort(this.serialize(key), params, this.serialize(storeKey));
    }

    @Override
    public List<String> sort(String key, SortParameters params) {
        return this.deserialize(this.delegate.sort(this.serialize(key), params));
    }

    @Override
    public String sPop(String key) {
        return this.deserialize(this.delegate.sPop(this.serialize(key)));
    }

    @Override
    public String sRandMember(String key) {
        return this.deserialize(this.delegate.sRandMember(this.serialize(key)));
    }

    @Override
    public Boolean sRem(String key, String value) {
        return this.delegate.sRem(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long strLen(String key) {
        return this.delegate.strLen(this.serialize(key));
    }

    @Override
    public void subscribe(MessageListener listener, String ... channels) {
        this.delegate.subscribe(listener, this.serializeMulti(channels));
    }

    @Override
    public Set<String> sUnion(String ... keys) {
        return this.deserialize(this.delegate.sUnion(this.serializeMulti(keys)));
    }

    @Override
    public void sUnionStore(String destKey, String ... keys) {
        this.delegate.sUnionStore(this.serialize(destKey), this.serializeMulti(keys));
    }

    @Override
    public Long ttl(String key) {
        return this.delegate.ttl(this.serialize(key));
    }

    @Override
    public DataType type(String key) {
        return this.delegate.type(this.serialize(key));
    }

    @Override
    public Boolean zAdd(String key, double score, String value) {
        return this.delegate.zAdd(this.serialize(key), score, this.serialize(value));
    }

    @Override
    public Long zCard(String key) {
        return this.delegate.zCard(this.serialize(key));
    }

    @Override
    public Long zCount(String key, double min, double max) {
        return this.delegate.zCount(this.serialize(key), min, max);
    }

    @Override
    public Double zIncrBy(String key, double increment, String value) {
        return this.delegate.zIncrBy(this.serialize(key), increment, this.serialize(value));
    }

    @Override
    public Long zInterStore(String destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, String ... sets) {
        return this.delegate.zInterStore(this.serialize(destKey), aggregate, weights, this.serializeMulti(sets));
    }

    @Override
    public Long zInterStore(String destKey, String ... sets) {
        return this.delegate.zInterStore(this.serialize(destKey), this.serializeMulti(sets));
    }

    @Override
    public Set<String> zRange(String key, long start, long end) {
        return this.deserialize(this.delegate.zRange(this.serialize(key), start, end));
    }

    @Override
    public Set<String> zRangeByScore(String key, double min, double max, long offset, long count) {
        return this.deserialize(this.delegate.zRangeByScore(this.serialize(key), min, max, offset, count));
    }

    @Override
    public Set<String> zRangeByScore(String key, double min, double max) {
        return this.deserialize(this.delegate.zRangeByScore(this.serialize(key), min, max));
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return this.deserializeTuple(this.delegate.zRangeByScoreWithScores(this.serialize(key), min, max, offset, count));
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeByScoreWithScores(String key, double min, double max) {
        return this.deserializeTuple(this.delegate.zRangeByScoreWithScores(this.serialize(key), min, max));
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRangeWithScores(String key, long start, long end) {
        return this.deserializeTuple(this.delegate.zRangeWithScores(this.serialize(key), start, end));
    }

    @Override
    public Long zRank(String key, String value) {
        return this.delegate.zRank(this.serialize(key), this.serialize(value));
    }

    @Override
    public Boolean zRem(String key, String value) {
        return this.delegate.zRem(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long zRemRange(String key, long start, long end) {
        return this.delegate.zRemRange(this.serialize(key), start, end);
    }

    @Override
    public Long zRemRangeByScore(String key, double min, double max) {
        return this.delegate.zRemRangeByScore(this.serialize(key), min, max);
    }

    @Override
    public Set<String> zRevRange(String key, long start, long end) {
        return this.deserialize(this.delegate.zRevRange(this.serialize(key), start, end));
    }

    @Override
    public Set<StringRedisConnection.StringTuple> zRevRangeWithScores(String key, long start, long end) {
        return this.deserializeTuple(this.delegate.zRevRangeWithScores(this.serialize(key), start, end));
    }

    @Override
    public Long zRevRank(String key, String value) {
        return this.delegate.zRevRank(this.serialize(key), this.serialize(value));
    }

    @Override
    public Double zScore(String key, String value) {
        return this.delegate.zScore(this.serialize(key), this.serialize(value));
    }

    @Override
    public Long zUnionStore(String destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, String ... sets) {
        return this.delegate.zUnionStore(this.serialize(destKey), aggregate, weights, this.serializeMulti(sets));
    }

    @Override
    public Long zUnionStore(String destKey, String ... sets) {
        return this.delegate.zUnionStore(this.serialize(destKey), this.serializeMulti(sets));
    }

    @Override
    public List<Object> closePipeline() {
        return this.delegate.closePipeline();
    }

    @Override
    public boolean isPipelined() {
        return this.delegate.isPipelined();
    }

    @Override
    public void openPipeline() {
        this.delegate.openPipeline();
    }
}

