/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.function.convert;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MappingR2dbcConverter {
    private final RelationalConverter relationalConverter;

    public MappingR2dbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        this((RelationalConverter)new BasicRelationalConverter(context));
    }

    public MappingR2dbcConverter(RelationalConverter converter) {
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        this.relationalConverter = converter;
    }

    public <T> BiFunction<Row, RowMetadata, T> populateIdIfNecessary(T object) {
        Assert.notNull(object, (String)"Entity object must not be null!");
        Class userClass = ClassUtils.getUserClass(object);
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(userClass);
        return (row, metadata) -> {
            RelationalPersistentProperty idProperty;
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(object);
            if (propertyAccessor.getProperty((PersistentProperty)(idProperty = (RelationalPersistentProperty)entity.getRequiredIdProperty())) == null && this.potentiallySetId((Row)row, (RowMetadata)metadata, (PersistentPropertyAccessor<?>)propertyAccessor, idProperty)) {
                return propertyAccessor.getBean();
            }
            return object;
        };
    }

    private boolean potentiallySetId(Row row, RowMetadata metadata, PersistentPropertyAccessor<?> propertyAccessor, RelationalPersistentProperty idProperty) {
        Map<String, ColumnMetadata> columns = MappingR2dbcConverter.createMetadataMap(metadata);
        Object generatedIdValue = null;
        if (columns.containsKey(idProperty.getColumnName())) {
            generatedIdValue = row.get((Object)idProperty.getColumnName());
        }
        if (columns.size() == 1) {
            String key = columns.keySet().iterator().next();
            generatedIdValue = row.get((Object)key);
        }
        if (generatedIdValue != null) {
            ConversionService conversionService = this.relationalConverter.getConversionService();
            propertyAccessor.setProperty((PersistentProperty)idProperty, conversionService.convert(generatedIdValue, idProperty.getType()));
            return true;
        }
        return false;
    }

    private static Map<String, ColumnMetadata> createMetadataMap(RowMetadata metadata) {
        LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
        for (ColumnMetadata column : metadata.getColumnMetadatas()) {
            columns.put(column.getName(), column);
        }
        return columns;
    }

    public MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> getMappingContext() {
        return this.relationalConverter.getMappingContext();
    }
}

