/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.Dialect;
import org.springframework.data.r2dbc.dialect.LimitClause;

public class SqlServerDialect
implements Dialect {
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class<UUID>>(Collections.singletonList(UUID.class));
    public static final SqlServerDialect INSTANCE = new SqlServerDialect();
    private static final BindMarkersFactory NAMED = BindMarkersFactory.named("@", "P", 32, SqlServerDialect::filterBindMarker);
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getClause(long limit) {
            return "OFFSET 0 ROWS FETCH NEXT " + limit + " ROWS ONLY";
        }

        @Override
        public String getClause(long limit, long offset) {
            return String.format("OFFSET %d ROWS FETCH NEXT %d ROWS ONLY", offset, limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.END;
        }
    };

    @Override
    public BindMarkersFactory getBindMarkersFactory() {
        return NAMED;
    }

    @Override
    public String generatedKeysClause() {
        return "select SCOPE_IDENTITY() AS GENERATED_KEYS";
    }

    @Override
    public Collection<? extends Class<?>> getSimpleTypes() {
        return SIMPLE_TYPES;
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    private static String filterBindMarker(CharSequence input) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (!Character.isLetterOrDigit(ch) || ch >= '\u007f') continue;
            builder.append(ch);
        }
        if (builder.length() == 0) {
            return "";
        }
        return "_" + builder.toString();
    }
}

