/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.util.function.Function;
import org.springframework.data.r2dbc.dialect.BindMarkers;
import org.springframework.data.r2dbc.dialect.IndexedBindMarkers;
import org.springframework.data.r2dbc.dialect.NamedBindMarkers;
import org.springframework.util.Assert;

@FunctionalInterface
public interface BindMarkersFactory {
    public BindMarkers create();

    public static BindMarkersFactory indexed(String prefix, int beginWith) {
        Assert.notNull((Object)prefix, (String)"Prefix must not be null!");
        return () -> new IndexedBindMarkers(prefix, beginWith);
    }

    public static BindMarkersFactory named(String prefix, String namePrefix, int maxLength) {
        return BindMarkersFactory.named(prefix, namePrefix, maxLength, Function.identity());
    }

    public static BindMarkersFactory named(String prefix, String namePrefix, int maxLength, Function<String, String> hintFilterFunction) {
        Assert.notNull((Object)prefix, (String)"Prefix must not be null!");
        Assert.notNull((Object)namePrefix, (String)"Index prefix must not be null!");
        Assert.notNull(hintFilterFunction, (String)"Hint filter function must not be null!");
        return () -> new NamedBindMarkers(prefix, namePrefix, maxLength, hintFilterFunction);
    }
}

