/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import org.springframework.web.server.session.WebSessionManager;

@Configuration
@ConditionalOnClass(value={DispatcherHandler.class, HttpHandler.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnMissingBean(value={HttpHandler.class})
@AutoConfigureAfter(value={WebFluxAutoConfiguration.class})
@AutoConfigureOrder(value=-2147483638)
public class HttpHandlerAutoConfiguration {

    @Configuration
    @ConditionalOnBean(value={RouterFunction.class})
    public static class FunctionalConfig {
        private final List<WebFilter> webFilters;
        private final WebSessionManager webSessionManager;
        private HandlerStrategies.Builder handlerStrategiesBuilder;
        private final List<ViewResolver> viewResolvers;

        public FunctionalConfig(ObjectProvider<List<WebFilter>> webFilters, ObjectProvider<WebSessionManager> webSessionManager, ObjectProvider<HandlerStrategies.Builder> handlerStrategiesBuilder, ObjectProvider<List<ViewResolver>> viewResolvers) {
            this.webFilters = (List)webFilters.getIfAvailable();
            if (this.webFilters != null) {
                AnnotationAwareOrderComparator.sort(this.webFilters);
            }
            this.webSessionManager = (WebSessionManager)webSessionManager.getIfAvailable();
            this.handlerStrategiesBuilder = (HandlerStrategies.Builder)handlerStrategiesBuilder.getIfAvailable();
            this.viewResolvers = (List)viewResolvers.getIfAvailable();
        }

        @Bean
        public HttpHandler httpHandler(List<RouterFunction<?>> routerFunctions) {
            routerFunctions.sort((Comparator<RouterFunction<?>>)new AnnotationAwareOrderComparator());
            RouterFunction routerFunction = (RouterFunction)routerFunctions.stream().reduce(RouterFunction::andOther).get();
            if (this.handlerStrategiesBuilder == null) {
                this.handlerStrategiesBuilder = HandlerStrategies.builder();
            }
            if (this.viewResolvers != null) {
                this.viewResolvers.forEach(arg_0 -> ((HandlerStrategies.Builder)this.handlerStrategiesBuilder).viewResolver(arg_0));
            }
            HttpWebHandlerAdapter webHandler = RouterFunctions.toHttpHandler((RouterFunction)routerFunction, (HandlerStrategies)this.handlerStrategiesBuilder.build());
            WebHttpHandlerBuilder builder = WebHttpHandlerBuilder.webHandler((WebHandler)webHandler).sessionManager(this.webSessionManager);
            builder.filters(this.webFilters);
            return builder.build();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RouterFunction.class})
    public static class AnnotationConfig {
        private ApplicationContext applicationContext;

        public AnnotationConfig(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Bean
        public HttpHandler httpHandler() {
            return WebHttpHandlerBuilder.applicationContext((ApplicationContext)this.applicationContext).build();
        }
    }
}

