/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.reactivestreams.client.MongoClient;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.ReactiveMongoClientFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={MongoClient.class})
@EnableConfigurationProperties(value={MongoProperties.class})
public class MongoReactiveAutoConfiguration {
    private final MongoClientSettings settings;
    private final ReactiveMongoClientFactory factory;
    private MongoClient mongo;

    public MongoReactiveAutoConfiguration(MongoProperties properties, ObjectProvider<MongoClientSettings> settings, Environment environment) {
        this.settings = (MongoClientSettings)settings.getIfAvailable();
        this.factory = new ReactiveMongoClientFactory(properties, environment);
    }

    @PreDestroy
    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoClient reactiveStreamsMongoClient() {
        this.mongo = this.factory.createMongoClient(this.settings);
        return this.mongo;
    }
}

