/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mobile;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.mobile.DeviceDelegatingViewResolverFactory;
import org.springframework.boot.autoconfigure.mobile.DeviceDelegatingViewResolverProperties;
import org.springframework.boot.autoconfigure.mustache.MustacheAutoConfiguration;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.view.MustacheViewResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.device.view.LiteDeviceDelegatingViewResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;
import org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={LiteDeviceDelegatingViewResolver.class})
@ConditionalOnProperty(prefix="spring.mobile.devicedelegatingviewresolver", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={DeviceDelegatingViewResolverProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, FreeMarkerAutoConfiguration.class, GroovyTemplateAutoConfiguration.class, MustacheAutoConfiguration.class, ThymeleafAutoConfiguration.class})
public class DeviceDelegatingViewResolverAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={ThymeleafViewResolver.class})
    protected static class DeviceDelegatingThymeleafViewResolverConfiguration {
        protected DeviceDelegatingThymeleafViewResolverConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ThymeleafViewResolver.class})
        public LiteDeviceDelegatingViewResolver deviceDelegatingThymeleafViewResolver(DeviceDelegatingViewResolverFactory factory, ThymeleafViewResolver viewResolver) {
            return factory.createViewResolver((ViewResolver)viewResolver);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MustacheViewResolver.class})
    protected static class DeviceDelegatingMustacheViewResolverConfiguration {
        protected DeviceDelegatingMustacheViewResolverConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={MustacheViewResolver.class})
        public LiteDeviceDelegatingViewResolver deviceDelegatingMustacheViewResolver(DeviceDelegatingViewResolverFactory factory, MustacheViewResolver viewResolver) {
            return factory.createViewResolver((ViewResolver)viewResolver);
        }
    }

    @Configuration
    @ConditionalOnClass(value={InternalResourceViewResolver.class})
    protected static class DeviceDelegatingJspViewResolverConfiguration {
        protected DeviceDelegatingJspViewResolverConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={InternalResourceViewResolver.class})
        public LiteDeviceDelegatingViewResolver deviceDelegatingJspViewResolver(DeviceDelegatingViewResolverFactory factory, InternalResourceViewResolver viewResolver) {
            return factory.createViewResolver((ViewResolver)viewResolver);
        }
    }

    @Configuration
    @ConditionalOnClass(value={GroovyMarkupViewResolver.class})
    protected static class DeviceDelegatingGroovyMarkupViewResolverConfiguration {
        protected DeviceDelegatingGroovyMarkupViewResolverConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={GroovyMarkupViewResolver.class})
        public LiteDeviceDelegatingViewResolver deviceDelegatingGroovyMarkupViewResolver(DeviceDelegatingViewResolverFactory factory, GroovyMarkupViewResolver viewResolver) {
            return factory.createViewResolver((ViewResolver)viewResolver);
        }
    }

    @Configuration
    @ConditionalOnClass(value={FreeMarkerViewResolver.class})
    protected static class DeviceDelegatingFreeMarkerViewResolverConfiguration {
        protected DeviceDelegatingFreeMarkerViewResolverConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={FreeMarkerViewResolver.class})
        public LiteDeviceDelegatingViewResolver deviceDelegatingFreeMarkerViewResolver(DeviceDelegatingViewResolverFactory factory, FreeMarkerViewResolver viewResolver) {
            return factory.createViewResolver((ViewResolver)viewResolver);
        }
    }

    @Configuration
    protected static class LiteDeviceDelegatingViewResolverFactoryConfiguration {
        protected LiteDeviceDelegatingViewResolverFactoryConfiguration() {
        }

        @Bean
        public DeviceDelegatingViewResolverFactory deviceDelegatingViewResolverFactory(DeviceDelegatingViewResolverProperties properties) {
            return new DeviceDelegatingViewResolverFactory(properties);
        }
    }
}

