/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformSameOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;

public abstract class BaseTransformBoolOp
extends BaseTransformOp
implements TransformSameOp {
    public BaseTransformBoolOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2) {
        super(sameDiff, i_v1, i_v2);
    }

    public BaseTransformBoolOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace) {
        super(sameDiff, i_v1, i_v2, inPlace);
    }

    public BaseTransformBoolOp(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        super(sameDiff, i_v, inPlace);
    }

    public BaseTransformBoolOp(SameDiff sameDiff) {
        super(sameDiff);
    }

    public BaseTransformBoolOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, Object[] extraArgs) {
        super(sameDiff, i_v1, i_v2, extraArgs);
    }

    public BaseTransformBoolOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
    }

    public BaseTransformBoolOp(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs) {
        super(sameDiff, i_v, extraArgs);
    }

    public BaseTransformBoolOp(INDArray x, INDArray z) {
        super(x, z);
    }

    public BaseTransformBoolOp(INDArray x, INDArray y, INDArray z) {
        super(x, y, z);
    }

    public BaseTransformBoolOp() {
    }

    public BaseTransformBoolOp(INDArray x) {
        super(x);
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.TRANSFORM_BOOL;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.TRANSFORM_BOOL;
    }

    @Override
    public DataType resultType() {
        return DataType.BOOL;
    }

    @Override
    public boolean validateDataTypes(boolean experimentalMode) {
        if (this.y() != null) {
            Preconditions.checkArgument((this.x().dataType() == this.y().dataType() ? 1 : 0) != 0, (String)"Op.X must be the same type as Op.Y: x.datatype=%s, y.datatype=%s", (Object)this.x().dataType(), (Object)this.y.dataType());
        }
        if (this.z() != null) {
            Preconditions.checkArgument((boolean)this.z().isB(), (String)"Op.Z type must be bool: z.datatype=%s for op %s", (Object)this.z().dataType(), this.getClass());
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(LongShapeDescriptor.fromShape(this.x.shape(), DataType.BOOL));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        SDVariable[] args = this.args();
        Preconditions.checkState((dataTypes != null && dataTypes.size() == args.length ? 1 : 0) != 0, (String)"Expected exactly %s input datatype(s) for %s, got input %s", (Object)args.length, this.getClass(), dataTypes);
        return Collections.singletonList(DataType.BOOL);
    }
}

