/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoException;
import com.mongodb.ReflectionDBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBCollection {
    final DB _db;
    protected final String _name;
    protected final String _fullName;
    protected List<DBObject> _hintFields;
    private WriteConcern _concern = null;
    final Bytes.OptionHolder _options;
    protected Class _objectClass = null;
    private Map<String, Class> _internalClass = Collections.synchronizedMap(new HashMap());
    private ReflectionDBObject.JavaWrapper _wrapper = null;
    private final Set<String> _createIndexes = new HashSet<String>();

    public abstract WriteResult insert(DBObject[] var1, WriteConcern var2) throws MongoException;

    public WriteResult insert(DBObject o, WriteConcern concern) throws MongoException {
        return this.insert(new DBObject[]{o}, concern);
    }

    public WriteResult insert(DBObject ... arr) throws MongoException {
        return this.insert(arr, this.getWriteConcern());
    }

    public WriteResult insert(List<DBObject> list) throws MongoException {
        return this.insert(list.toArray(new DBObject[list.size()]), this.getWriteConcern());
    }

    public abstract WriteResult update(DBObject var1, DBObject var2, boolean var3, boolean var4, WriteConcern var5) throws MongoException;

    public WriteResult update(DBObject q, DBObject o, boolean upsert, boolean multi) throws MongoException {
        return this.update(q, o, upsert, multi, this.getWriteConcern());
    }

    public WriteResult update(DBObject q, DBObject o) throws MongoException {
        return this.update(q, o, false, false);
    }

    public WriteResult updateMulti(DBObject q, DBObject o) throws MongoException {
        return this.update(q, o, false, true);
    }

    protected abstract void doapply(DBObject var1);

    public abstract WriteResult remove(DBObject var1, WriteConcern var2) throws MongoException;

    public WriteResult remove(DBObject o) throws MongoException {
        return this.remove(o, this.getWriteConcern());
    }

    abstract Iterator<DBObject> __find(DBObject var1, DBObject var2, int var3, int var4, int var5) throws MongoException;

    public final DBCursor find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int options) throws MongoException {
        return this.find(ref, fields, numToSkip, batchSize).addOption(options);
    }

    public final DBCursor find(DBObject ref, DBObject fields, int numToSkip, int batchSize) {
        DBCursor cursor = this.find(ref, fields).skip(numToSkip).batchSize(batchSize);
        if (batchSize < 0) {
            cursor.limit(Math.abs(batchSize));
        }
        return cursor;
    }

    Iterator<DBObject> __find(DBObject ref, DBObject fields, int numToSkip, int batchSize) throws MongoException {
        return this.__find(ref, fields, numToSkip, batchSize, this.getOptions());
    }

    public abstract void createIndex(DBObject var1, DBObject var2) throws MongoException;

    public final DBObject findOne(Object obj) throws MongoException {
        return this.findOne(obj, null);
    }

    public final DBObject findOne(Object obj, DBObject fields) {
        Iterator<DBObject> iterator = this.__find(new BasicDBObject("_id", obj), fields, 0, -1, this.getOptions());
        return iterator != null ? iterator.next() : null;
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert) {
        BasicDBObject cmd = new BasicDBObject("findandmodify", this._name);
        if (query != null && !query.keySet().isEmpty()) {
            cmd.append("query", query);
        }
        if (fields != null && !fields.keySet().isEmpty()) {
            cmd.append("fields", fields);
        }
        if (sort != null && !sort.keySet().isEmpty()) {
            cmd.append("sort", sort);
        }
        if (remove) {
            cmd.append("remove", remove);
        } else {
            if (update != null && !update.keySet().isEmpty()) {
                cmd.append("update", update);
            }
            if (returnNew) {
                cmd.append("new", returnNew);
            }
            if (upsert) {
                cmd.append("upsert", upsert);
            }
        }
        if (remove && update != null && !update.keySet().isEmpty() && !returnNew) {
            throw new MongoException("FindAndModify: Remove cannot be mixed with the Update, or returnNew params!");
        }
        return (DBObject)this._db.command(cmd).get("value");
    }

    public DBObject findAndModify(DBObject query, DBObject sort, DBObject update) {
        return this.findAndModify(query, null, null, false, update, false, false);
    }

    public DBObject findAndModify(DBObject query, DBObject update) {
        return this.findAndModify(query, null, null, false, update, false, false);
    }

    public DBObject findAndRemove(DBObject query) {
        return this.findAndModify(query, null, null, true, null, false, false);
    }

    public final void createIndex(DBObject keys) throws MongoException {
        this.createIndex(keys, this.defaultOptions(keys));
    }

    public final void ensureIndex(String name) {
        this.ensureIndex(new BasicDBObject(name, (Object)1));
    }

    public final void ensureIndex(DBObject keys) throws MongoException {
        this.ensureIndex(keys, this.defaultOptions(keys));
    }

    public void ensureIndex(DBObject keys, String name) throws MongoException {
        this.ensureIndex(keys, name, false);
    }

    public void ensureIndex(DBObject keys, String name, boolean unique) throws MongoException {
        DBObject options = this.defaultOptions(keys);
        options.put("name", name);
        if (unique) {
            options.put("unique", Boolean.TRUE);
        }
        this.ensureIndex(keys, options);
    }

    public final void ensureIndex(DBObject keys, DBObject optionsIN) throws MongoException {
        if (this.checkReadOnly(false)) {
            return;
        }
        DBObject options = this.defaultOptions(keys);
        for (String k : optionsIN.keySet()) {
            options.put(k, optionsIN.get(k));
        }
        String name = options.get("name").toString();
        if (this._createIndexes.contains(name)) {
            return;
        }
        this.createIndex(keys, options);
        this._createIndexes.add(name);
    }

    public void resetIndexCache() {
        this._createIndexes.clear();
    }

    DBObject defaultOptions(DBObject keys) {
        BasicDBObject o = new BasicDBObject();
        o.put("name", (Object)DBCollection.genIndexName(keys));
        o.put("ns", (Object)this._fullName);
        return o;
    }

    public static String genIndexName(DBObject keys) {
        String name = "";
        for (String s : keys.keySet()) {
            if (name.length() > 0) {
                name = name + "_";
            }
            name = name + s + "_";
            Object val = keys.get(s);
            if (!(val instanceof Number) && !(val instanceof String)) continue;
            name = name + val.toString().replace(' ', '_');
        }
        return name;
    }

    public void setHintFields(List<DBObject> lst) {
        this._hintFields = lst;
    }

    public final DBCursor find(DBObject ref) {
        return new DBCursor(this, ref, null);
    }

    public final DBCursor find(DBObject ref, DBObject keys) {
        return new DBCursor(this, ref, keys);
    }

    public final DBCursor find() {
        return new DBCursor(this, new BasicDBObject(), null);
    }

    public final DBObject findOne() throws MongoException {
        return this.findOne(new BasicDBObject());
    }

    public final DBObject findOne(DBObject o) throws MongoException {
        return this.findOne(o, null);
    }

    public final DBObject findOne(DBObject o, DBObject fields) {
        Iterator<DBObject> i = this.__find(o, fields, 0, -1, this.getOptions());
        if (i == null || !i.hasNext()) {
            return null;
        }
        return i.next();
    }

    public final Object apply(DBObject o) {
        return this.apply(o, true);
    }

    public final Object apply(DBObject jo, boolean ensureID) {
        Object id = jo.get("_id");
        if (ensureID && id == null) {
            id = ObjectId.get();
            jo.put("_id", id);
        }
        this.doapply(jo);
        return id;
    }

    public final WriteResult save(DBObject jo) {
        return this.save(jo, null);
    }

    public final WriteResult save(DBObject jo, WriteConcern concern) throws MongoException {
        if (this.checkReadOnly(true)) {
            return null;
        }
        this._checkObject(jo, false, false);
        Object id = jo.get("_id");
        if (id == null || id instanceof ObjectId && ((ObjectId)id).isNew()) {
            if (id != null && id instanceof ObjectId) {
                ((ObjectId)id).notNew();
            }
            if (concern == null) {
                return this.insert(jo);
            }
            return this.insert(jo, concern);
        }
        BasicDBObject q = new BasicDBObject();
        q.put("_id", id);
        if (concern == null) {
            return this.update(q, jo, true, false);
        }
        return this.update(q, jo, true, false, concern);
    }

    public void dropIndexes() throws MongoException {
        this.dropIndexes("*");
    }

    public void dropIndexes(String name) throws MongoException {
        DBObject cmd = BasicDBObjectBuilder.start().add("deleteIndexes", this.getName()).add("index", name).get();
        CommandResult res = this._db.command(cmd);
        if (res.ok() || res.getErrorMessage().equals("ns not found")) {
            this.resetIndexCache();
            return;
        }
        throw new MongoException("error dropping indexes : " + res);
    }

    public void drop() throws MongoException {
        this.resetIndexCache();
        CommandResult res = this._db.command(BasicDBObjectBuilder.start().add("drop", this.getName()).get());
        if (res.ok() || res.getErrorMessage().equals("ns not found")) {
            return;
        }
        throw new MongoException("error dropping : " + res);
    }

    public long count() throws MongoException {
        return this.getCount(new BasicDBObject(), null);
    }

    public long count(DBObject query) throws MongoException {
        return this.getCount(query, null);
    }

    public long getCount() throws MongoException {
        return this.getCount(new BasicDBObject(), null);
    }

    public long getCount(DBObject query) throws MongoException {
        return this.getCount(query, null);
    }

    public long getCount(DBObject query, DBObject fields) throws MongoException {
        return this.getCount(query, fields, 0L, 0L);
    }

    public long getCount(DBObject query, DBObject fields, long limit, long skip) throws MongoException {
        CommandResult res;
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("count", (Object)this.getName());
        cmd.put("query", (Object)query);
        if (fields != null) {
            cmd.put("fields", (Object)fields);
        }
        if (limit > 0L) {
            cmd.put("limit", (Object)limit);
        }
        if (skip > 0L) {
            cmd.put("skip", (Object)skip);
        }
        if (!(res = this._db.command(cmd, this.getOptions())).ok()) {
            String errmsg = res.getErrorMessage();
            if (errmsg.equals("ns does not exist") || errmsg.equals("ns missing")) {
                return 0L;
            }
            throw new MongoException("error counting : " + res);
        }
        return res.getLong("n");
    }

    public DBCollection rename(String newName) throws MongoException {
        CommandResult ret = this._db.getSisterDB("admin").command(BasicDBObjectBuilder.start().add("renameCollection", this._fullName).add("to", this._db._name + "." + newName).get());
        ret.throwOnError();
        this.resetIndexCache();
        return this._db.getCollection(newName);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce) throws MongoException {
        CommandResult res = this._db.command(new BasicDBObject("group", BasicDBObjectBuilder.start().add("ns", this.getName()).add("key", key).add("cond", cond).add("$reduce", reduce).add("initial", initial).get()));
        res.throwOnError();
        return (DBObject)res.get("retval");
    }

    public List distinct(String key) {
        return this.distinct(key, new BasicDBObject());
    }

    public List distinct(String key, DBObject query) {
        DBObject c = BasicDBObjectBuilder.start().add("distinct", this.getName()).add("key", key).add("query", query).get();
        CommandResult res = this._db.command(c);
        res.throwOnError();
        return (List)res.get("values");
    }

    public MapReduceOutput mapReduce(String map, String reduce, String outputCollection, DBObject query) throws MongoException {
        BasicDBObjectBuilder b = BasicDBObjectBuilder.start().add("mapreduce", this._name).add("map", map).add("reduce", reduce);
        if (outputCollection != null) {
            b.add("out", outputCollection);
        }
        if (query != null) {
            b.add("query", query);
        }
        return this.mapReduce(b.get());
    }

    public MapReduceOutput mapReduce(DBObject command) throws MongoException {
        if (command.get("mapreduce") == null) {
            throw new IllegalArgumentException("need mapreduce arg");
        }
        CommandResult res = this._db.command(command);
        res.throwOnError();
        return new MapReduceOutput(this, res);
    }

    public List<DBObject> getIndexInfo() {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("ns", (Object)this.getFullName());
        DBCursor cur = this._db.getCollection("system.indexes").find(cmd);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        while (cur.hasNext()) {
            list.add(cur.next());
        }
        return list;
    }

    public void dropIndex(DBObject keys) throws MongoException {
        this.dropIndexes(DBCollection.genIndexName(keys));
    }

    public void dropIndex(String name) throws MongoException {
        this.dropIndexes(name);
    }

    public CommandResult getStats() {
        return this.getDB().command(new BasicDBObject("collstats", this.getName()));
    }

    public boolean isCapped() {
        CommandResult stats = this.getStats();
        Object capped = stats.get("capped");
        return capped != null && (Integer)capped == 1;
    }

    protected DBCollection(DB base, String name) {
        this._db = base;
        this._name = name;
        this._fullName = this._db.getName() + "." + name;
        this._options = new Bytes.OptionHolder(this._db._options);
    }

    private DBObject _checkObject(DBObject o, boolean canBeNull, boolean query) {
        if (o == null) {
            if (canBeNull) {
                return null;
            }
            throw new IllegalArgumentException("can't be null");
        }
        if (o.isPartialObject() && !query) {
            throw new IllegalArgumentException("can't save partial objects");
        }
        if (!query) {
            this._checkKeys(o);
        }
        return o;
    }

    private void _checkKeys(DBObject o) {
        for (String s : o.keySet()) {
            if (s.contains(".")) {
                throw new IllegalArgumentException("fields stored in the db can't have . in them");
            }
            if (s.charAt(0) == '$') {
                throw new IllegalArgumentException("fields stored in the db can't start with '$'");
            }
            Object inner = o.get(s);
            if (!(inner instanceof DBObject)) continue;
            this._checkKeys((DBObject)inner);
        }
    }

    public DBCollection getCollection(String n) {
        return this._db.getCollection(this._name + "." + n);
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._fullName;
    }

    public DB getDB() {
        return this._db;
    }

    protected boolean checkReadOnly(boolean strict) {
        if (!this._db._readOnly) {
            return false;
        }
        if (!strict) {
            return true;
        }
        throw new IllegalStateException("db is read only");
    }

    public int hashCode() {
        return this._fullName.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public String toString() {
        return this._name;
    }

    public void setObjectClass(Class c) {
        if (!DBObject.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(c.getName() + " is not a DBObject");
        }
        this._objectClass = c;
        this._wrapper = ReflectionDBObject.class.isAssignableFrom(c) ? ReflectionDBObject.getWrapper(c) : null;
    }

    public Class getObjectClass() {
        return this._objectClass;
    }

    public void setInternalClass(String path, Class c) {
        this._internalClass.put(path, c);
    }

    protected Class getInternalClass(String path) {
        Class c = this._internalClass.get(path);
        if (c != null) {
            return c;
        }
        if (this._wrapper == null) {
            return null;
        }
        return this._wrapper.getInternalClass(path);
    }

    public void setWriteConcern(WriteConcern concern) {
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._db.getWriteConcern();
    }

    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._options.add(option);
    }

    public void setOptions(int options) {
        this._options.set(options);
    }

    public void resetOptions() {
        this._options.reset();
    }

    public int getOptions() {
        return this._options.get();
    }
}

